/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.fragment;

import android.support.v4.app.Fragment;
import com.minggo.pluto.util.LogUtils;
import java.util.List;

public class FragmentUserVisibleController {
    private static final boolean DEBUG = true;
    private static final String TAG = "FragmentUserVisibleController";
    private String fragmentName;
    private boolean waitingShowToUser;
    private Fragment fragment;
    private UserVisibleCallback userVisibleCallback;

    public FragmentUserVisibleController(Fragment fragment, UserVisibleCallback userVisibleCallback) {
        this.fragment = fragment;
        this.userVisibleCallback = userVisibleCallback;
        this.fragmentName = fragment.getClass().getSimpleName();
    }

    public void activityCreated() {
        Fragment parentFragment;
        if (this.fragment.getUserVisibleHint() && (parentFragment = this.fragment.getParentFragment()) != null && !parentFragment.getUserVisibleHint()) {
            LogUtils.info(TAG, this.fragmentName + ": activityCreated, parent " + parentFragment.getClass().getSimpleName() + "is hidden, therefore hidden self");
            this.userVisibleCallback.setWaitingShowToUser(true);
            this.userVisibleCallback.callSuperSetUserVisibleHint(false);
        }
    }

    public void resume() {
        if (this.fragment.getUserVisibleHint()) {
            this.userVisibleCallback.onVisibleToUserChanged(true, true);
        }
    }

    public void pause() {
        if (this.fragment.getUserVisibleHint()) {
            this.userVisibleCallback.onVisibleToUserChanged(false, true);
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        block4: {
            List childFragmentList;
            block5: {
                if (this.fragment.isResumed()) {
                    this.userVisibleCallback.onVisibleToUserChanged(isVisibleToUser, false);
                }
                if (this.fragment.getActivity() == null) break block4;
                childFragmentList = this.fragment.getChildFragmentManager().getFragments();
                if (!isVisibleToUser) break block5;
                if (childFragmentList == null || childFragmentList.size() <= 0) break block4;
                for (Fragment childFragment : childFragmentList) {
                    UserVisibleCallback userVisibleCallback;
                    if (!(childFragment instanceof UserVisibleCallback) || !(userVisibleCallback = (UserVisibleCallback)childFragment).isWaitingShowToUser()) continue;
                    LogUtils.info(TAG, this.fragmentName + ": setUserVisibleHint, show child " + childFragment.getClass().getSimpleName());
                    userVisibleCallback.setWaitingShowToUser(false);
                    childFragment.setUserVisibleHint(true);
                }
                break block4;
            }
            if (childFragmentList != null && childFragmentList.size() > 0) {
                for (Fragment childFragment : childFragmentList) {
                    if (!(childFragment instanceof UserVisibleCallback)) continue;
                    UserVisibleCallback userVisibleCallback = (UserVisibleCallback)childFragment;
                    if (!childFragment.getUserVisibleHint()) continue;
                    LogUtils.info(TAG, this.fragmentName + ": setUserVisibleHint, hidden child " + childFragment.getClass().getSimpleName());
                    userVisibleCallback.setWaitingShowToUser(true);
                    childFragment.setUserVisibleHint(false);
                }
            }
        }
    }

    public boolean isVisibleToUser() {
        return this.fragment.isResumed() && this.fragment.getUserVisibleHint();
    }

    public boolean isWaitingShowToUser() {
        return this.waitingShowToUser;
    }

    public void setWaitingShowToUser(boolean waitingShowToUser) {
        this.waitingShowToUser = waitingShowToUser;
    }

    public static interface UserVisibleCallback {
        public void setWaitingShowToUser(boolean var1);

        public boolean isWaitingShowToUser();

        public boolean isVisibleToUser();

        public void callSuperSetUserVisibleHint(boolean var1);

        public void onVisibleToUserChanged(boolean var1, boolean var2);
    }
}

