/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import com.minggo.pluto.R;
import com.minggo.pluto.util.DisplayUtil;

public class PlutoDialog {
    private Context context;
    private int type;
    public static final int DEFAULT = 0;
    public static final int LOADING = 1;
    public static final int TEXT_ONLIY = 2;
    public static final int DEFAULT_EXIT = 3;
    private AlertDialog.Builder builder;
    private AlertDialog alertDialog;
    private View mainView;
    private int screenWidthPixels;
    private float _20Pixels;
    private String content;
    private String title;
    private String leftText;
    private String rightText;
    private PlutoDialogListener listener;

    public PlutoDialog(Context context, int type) {
        this.context = context;
        this.type = type;
        this.calcWidth();
    }

    public PlutoDialog(Context context, int type, String content) {
        this.context = context;
        this.type = type;
        this.content = content;
        this.calcWidth();
    }

    public PlutoDialog(Context context, int type, PlutoDialogListener listener) {
        this.context = context;
        this.type = type;
        this.listener = listener;
        this.calcWidth();
    }

    public PlutoDialog(Context context, int type, String content, PlutoDialogListener listener) {
        this.context = context;
        this.type = type;
        this.content = content;
        this.listener = listener;
        this.calcWidth();
    }

    public PlutoDialog(Context context, int type, String title, String content, String leftText, String rightText, PlutoDialogListener listener) {
        this.context = context;
        this.type = type;
        this.title = title;
        this.content = content;
        this.leftText = leftText;
        this.rightText = rightText;
        this.listener = listener;
        this.calcWidth();
    }

    public void show() {
        this.creatDialog();
        if (this.type != 0 && 3 != this.type) {
            this.alertDialog = this.builder.create();
            this.alertDialog.show();
            WindowManager.LayoutParams params = this.alertDialog.getWindow().getAttributes();
            params.width = (int)((float)this.screenWidthPixels - this._20Pixels * 2.0f);
            this.alertDialog.getWindow().setAttributes(params);
        }
    }

    private void creatDialog() {
        this.builder = new AlertDialog.Builder(this.context);
        switch (this.type) {
            case 0: {
                this.alertDialog = new AlertDialog.Builder(this.context).setTitle((CharSequence)this.title).setMessage((CharSequence)this.content).setNegativeButton((CharSequence)this.leftText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        PlutoDialog.this.listener.cancel();
                    }
                }).setPositiveButton((CharSequence)this.rightText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        PlutoDialog.this.listener.confirm();
                        PlutoDialog.this.alertDialog.dismiss();
                        PlutoDialog.this.alertDialog.cancel();
                    }
                }).show();
                break;
            }
            case 3: {
                this.alertDialog = new AlertDialog.Builder(this.context).setTitle(R.string.exit_title).setMessage(R.string.exit_content).setNegativeButton(R.string.exit_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        PlutoDialog.this.listener.cancel();
                    }
                }).setPositiveButton(R.string.exit_confirm, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        PlutoDialog.this.listener.confirm();
                        PlutoDialog.this.alertDialog.dismiss();
                        PlutoDialog.this.alertDialog.cancel();
                    }
                }).show();
                break;
            }
            case 1: {
                this.mainView = View.inflate((Context)this.context, (int)R.layout.dialog_progress, null);
                break;
            }
            case 2: {
                this.mainView = View.inflate((Context)this.context, (int)R.layout.dialog_text, null);
                break;
            }
        }
        this.initUI();
    }

    private void initUI() {
        if (this.type == 1) {
            this.builder.setView(this.mainView);
        } else if (this.type == 2) {
            this.builder.setView(this.mainView);
            ((TextView)this.mainView.findViewById(R.id.tv_dialog_tips)).setText((CharSequence)this.content);
        }
    }

    private void calcWidth() {
        this.screenWidthPixels = DisplayUtil.getScreenWidthPixels(this.context);
        this._20Pixels = DisplayUtil.dip2pxByFloat(this.context, 20.0f);
    }

    public boolean isShowing() {
        return this.alertDialog != null && this.alertDialog.isShowing();
    }

    public void dismiss() {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
        }
    }

    public void cancel() {
        if (this.alertDialog != null) {
            this.alertDialog.cancel();
        }
    }

    public void setCancelable(boolean b) {
        if (this.alertDialog != null) {
            this.alertDialog.setCancelable(b);
        } else if (this.builder != null) {
            this.builder.setCancelable(b);
        }
    }

    public static interface PlutoDialogListener {
        public void confirm();

        public void cancel();
    }
}

