/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.minggo.pluto.common.AsyncTaskManager;
import com.minggo.pluto.util.NetworkUtils;
import com.minggo.pluto.util.StringUtils;

public class AppContext {
    private static AppContext appContext;
    private AsyncTaskManager asyncTaskManager;
    private String mPlatformId;
    public Context context;

    public static void initAppContent(Context context) {
        AppContext appContext = AppContext.getInstance();
        appContext.context = context;
    }

    public static AppContext getInstance() {
        if (null == appContext) {
            appContext = new AppContext();
        }
        return appContext;
    }

    public AsyncTaskManager getAsyncTaskManager() {
        if (this.asyncTaskManager == null) {
            this.asyncTaskManager = new AsyncTaskManager();
        }
        return this.asyncTaskManager;
    }

    public boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected(this.context);
    }

    public static boolean isNetworkConnected(Context context) {
        return NetworkUtils.isNetworkConnected(context);
    }

    public int getNetworkType() {
        return NetworkUtils.getNetworkType(this.context);
    }

    public String getAndroidId(int bookid) {
        String android_id = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        if (android_id == null || android_id == "") {
            android_id = Build.VERSION.RELEASE + Build.MODEL + bookid;
        }
        if (StringUtils.isEmpty(android_id)) {
            android_id = "";
        }
        return android_id;
    }

    public String getAndroidIMEI() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        String imei = telephonyManager.getDeviceId();
        if (!StringUtils.isEmpty(imei)) {
            return imei;
        }
        return "this_phone_has_no_imei";
    }

    public String GetMobileVersion() {
        return Build.MODEL;
    }

    public String GetAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    public PackageInfo getPackageInfo() {
        PackageInfo info = null;
        try {
            info = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace(System.err);
        }
        if (info == null) {
            info = new PackageInfo();
        }
        return info;
    }
}

