/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import com.minggo.pluto.bitmap.Downloader;
import com.minggo.pluto.util.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SimpleHttpDownloader
implements Downloader {
    private static final String TAG = "BitmapDownloader";
    private static final int IO_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadToLocalStreamByUrl(String urlString, OutputStream outputStream) {
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        FilterInputStream in = null;
        try {
            int b;
            if (urlString.contains("http")) {
                URL url = new URL(urlString);
                urlConnection = (HttpURLConnection)url.openConnection();
                in = new FlushedInputStream(new BufferedInputStream(urlConnection.getInputStream(), 8192));
            } else {
                FileInputStream inputStream = new FileInputStream(urlString);
                in = new FlushedInputStream(new BufferedInputStream(inputStream, 8192));
            }
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                ((BufferedOutputStream)out).write(b);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogUtils.error(TAG, "Error in downloadBitmap - " + urlString + " : " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped;
            long bytesSkipped;
            for (totalBytesSkipped = 0L; totalBytesSkipped < n; totalBytesSkipped += bytesSkipped) {
                bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped != 0L) continue;
                int by_te = this.read();
                if (by_te < 0) break;
                bytesSkipped = 1L;
            }
            return totalBytesSkipped;
        }
    }
}

