/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.minggo.pluto.bitmap.BitmapDisplayConfig;
import com.minggo.pluto.bitmap.Displayer;

public class SimpleDisplayer
implements Displayer {
    @Override
    public void loadCompletedisplay(ImageView imageView, Bitmap bitmap, BitmapDisplayConfig config) {
        switch (config.getAnimationType()) {
            case 1: {
                this.fadeInDisplay(imageView, bitmap);
                break;
            }
            case 0: {
                this.animationDisplay(imageView, bitmap, config.getAnimation());
                break;
            }
        }
    }

    @Override
    public void loadFailDisplay(ImageView imageView, Bitmap bitmap) {
        imageView.setImageBitmap(bitmap);
    }

    private void fadeInDisplay(ImageView imageView, Bitmap bitmap) {
        TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), new BitmapDrawable(imageView.getResources(), bitmap)});
        imageView.setImageDrawable((Drawable)td);
        td.startTransition(300);
    }

    private void animationDisplay(ImageView imageView, Bitmap bitmap, Animation animation) {
        animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        imageView.setImageBitmap(bitmap);
        imageView.startAnimation(animation);
    }
}

