/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class BitmapCommonUtils {
    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) ? BitmapCommonUtils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static File getExternalCacheDir(Context context) {
        return new File(Environment.getExternalStorageDirectory().getPath());
    }

    public static long getUsableSpace(File path) {
        StatFs stats = new StatFs(Environment.getExternalStorageDirectory().getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }
}

