/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.DrawableRes;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import com.minggo.pluto.activity.IActivity;
import com.minggo.pluto.common.AppManager;
import com.minggo.pluto.common.CommonAsyncTask;
import com.minggo.pluto.dialog.PlutoDialog;
import com.minggo.pluto.util.LogUtils;
import com.minggo.pluto.util.NetworkUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Timer;

public abstract class PlutoActivity
extends AppCompatActivity
implements IActivity {
    protected Handler mUiHandler = new UiHandler(this);
    private final String pageName = this.getClass().getSimpleName();
    private Toast toast = null;
    protected Timer timer;
    protected int timerPeriod = 1000;
    protected PlutoDialog loadingDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AppManager.getAppManager().addActivity((Activity)this);
        this.showHomeAsUp();
        this.initLoadingDialog();
    }

    private void initLoadingDialog() {
        this.loadingDialog = new PlutoDialog((Context)this, 1);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.stopTimer();
        AppManager.getAppManager().finishActivity((Activity)this);
    }

    protected void onResume() {
        super.onResume();
        LogUtils.umengOnResume(this.pageName);
    }

    protected void onPause() {
        super.onPause();
        LogUtils.umengOnPause(this.pageName);
    }

    protected void cancelAsyncTask(CommonAsyncTask<?, ?, ?> ... asyncTasks) {
        for (CommonAsyncTask<?, ?, ?> asyncTask : asyncTasks) {
            if (asyncTask == null || asyncTask.isCancelled()) continue;
            asyncTask.cancel(true);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void setupActions(ArrayList<String> actions) {
    }

    @Override
    public void handleUiMessage(Message msg) {
    }

    protected void sendUiMessageDelayed(Message msg, long delayMillis) {
    }

    protected void sendEmptyUiMessage(int what) {
        this.mUiHandler.sendEmptyMessage(what);
    }

    protected void sendEmptyUiMessageDelayed(int what, long delayMillis) {
        this.mUiHandler.sendEmptyMessageDelayed(what, delayMillis);
    }

    protected void removeUiMessages(int what) {
        this.mUiHandler.removeMessages(what);
    }

    protected Message obtainUiMessage() {
        return this.mUiHandler.obtainMessage();
    }

    public void showToast(int strResId) {
        String text = this.getString(strResId);
        this.showToast(text);
    }

    public void showToast(final String showText) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (PlutoActivity.this.toast == null) {
                    PlutoActivity.this.toast = Toast.makeText((Context)PlutoActivity.this, (CharSequence)showText, (int)0);
                } else {
                    PlutoActivity.this.toast.setText((CharSequence)showText);
                    PlutoActivity.this.toast.setDuration(0);
                }
                PlutoActivity.this.toast.show();
            }
        });
    }

    protected void hideSoftInput(Context context) {
        InputMethodManager manager = (InputMethodManager)context.getSystemService("input_method");
        if (this.getCurrentFocus() != null) {
            manager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
        }
    }

    protected void showSoftInput() {
        InputMethodManager manager = (InputMethodManager)this.getSystemService("input_method");
        manager.toggleSoftInput(1, 0);
    }

    public boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected((Context)this);
    }

    public Handler getmUiHandler() {
        return this.mUiHandler;
    }

    @Override
    public void handleBroadcast(Context context, Intent intent) {
    }

    protected void showHomeAsUp() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    protected void hideHomeAsUp() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(false);
        }
    }

    protected void setHomeAsUpIndicator(@DrawableRes int resId) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setHomeAsUpIndicator(resId);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.homeMenuOnClick();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void homeMenuOnClick() {
        this.onBackPressed();
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private static class UiHandler
    extends Handler {
        private final WeakReference<PlutoActivity> mActivityReference;

        public UiHandler(PlutoActivity activity) {
            this.mActivityReference = new WeakReference<PlutoActivity>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.mActivityReference.get() != null) {
                ((PlutoActivity)this.mActivityReference.get()).handleUiMessage(msg);
            }
        }
    }
}

