/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.symmetric;

import android.os.Build;
import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.PRNGFixes;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import com.pvryan.easycrypt.symmetric.ECSymmetric;
import com.pvryan.easycrypt.symmetric.ECSymmetricTransformations;
import com.pvryan.easycrypt.symmetric.performDecrypt;
import com.pvryan.easycrypt.symmetric.performEncrypt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\b\b\u0001\u0010\u000b\u001a\u0002H\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J;\u0010\u0013\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\b\b\u0001\u0010\u000b\u001a\u0002H\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pvryan/easycrypt/symmetric/ECSymmetric;", "", "transformation", "Lcom/pvryan/easycrypt/symmetric/ECSymmetricTransformations;", "(Lcom/pvryan/easycrypt/symmetric/ECSymmetricTransformations;)V", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "decrypt", "", "T", "input", "password", "", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "(Ljava/lang/Object;Ljava/lang/String;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "encrypt", "getKey", "Ljavax/crypto/spec/SecretKeySpec;", "salt", "", "easycrypt_release"})
public final class ECSymmetric {
    private final Cipher cipher;

    private final SecretKeySpec getKey(String password, byte[] salt) throws InvalidKeySpecException {
        PBEKeySpec pBEKeySpec;
        String string = password;
        PBEKeySpec pBEKeySpec2 = pBEKeySpec;
        PBEKeySpec pBEKeySpec3 = pBEKeySpec;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Object object = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String string3 = string = object;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        object = cArray;
        pBEKeySpec2((char[])object, salt, 10000, 256);
        PBEKeySpec pbeKeySpec = pBEKeySpec3;
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(Constants.Companion.getSECRET_KEY_FAC_ALGORITHM());
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKeyFactory, (String)"SecretKeyFactory.getInst\u2026SECRET_KEY_FAC_ALGORITHM)");
        SecretKeyFactory keyFactory = secretKeyFactory;
        SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"keyFactory.generateSecret(pbeKeySpec)");
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"keyFactory.generateSecret(pbeKeySpec).encoded");
        byte[] keyBytes = byArray;
        return new SecretKeySpec(keyBytes, "AES");
    }

    static /* bridge */ /* synthetic */ SecretKeySpec getKey$default(ECSymmetric eCSymmetric, String string, byte[] byArray, int n, Object object) throws InvalidKeySpecException {
        if ((n & 1) != 0) {
            string = new String();
        }
        return eCSymmetric.getKey(string, byArray);
    }

    @JvmOverloads
    public final <T> void encrypt(@NotNull T input, @NotNull String password, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECSymmetric>, Unit>(this, password, input, erl, outputFile){
            final /* synthetic */ ECSymmetric this$0;
            final /* synthetic */ String $password;
            final /* synthetic */ Object $input;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ File $outputFile;

            public final void invoke(@NotNull AnkoAsyncContext<ECSymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Object object = this.$password;
                String string = object;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String tPass = ((Object)StringsKt.trim((CharSequence)string)).toString();
                object = this.$input;
                if (object instanceof String) {
                    this.this$0.encrypt(DataTypeExtensionsKt.asByteArray((String)this.$input), this.$password, this.$erl, this.$outputFile);
                } else if (object instanceof CharSequence) {
                    this.this$0.encrypt(DataTypeExtensionsKt.asByteArray(this.$input.toString()), this.$password, this.$erl, this.$outputFile);
                } else if (object instanceof ByteArrayInputStream) {
                    this.this$0.encrypt(ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.$input), (int)0, (int)1, null), this.$password, this.$erl, this.$outputFile);
                } else if (object instanceof File) {
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$erl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    File encryptedFile = Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ? new File(((File)this.$input).getAbsolutePath() + ".ecrypt") : this.$outputFile;
                    File file = (File)this.$input;
                    ECSymmetric eCSymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCSymmetric.encrypt(fileInputStream, this.$password, this.$erl, encryptedFile);
                } else {
                    Cipher cipher = ECSymmetric.access$getCipher$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"cipher");
                    performEncrypt.INSTANCE.invoke$easycrypt_release(this.$input, tPass, cipher, (Function2<? super String, ? super byte[], ? extends SecretKeySpec>)((Function2)new Function2<String, byte[], SecretKeySpec>(this){
                        final /* synthetic */ encrypt.1 this$0;

                        @NotNull
                        public final SecretKeySpec invoke(@NotNull String pass, @NotNull byte[] salt) {
                            Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
                            Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
                            return ECSymmetric.access$getKey(this.this$0.this$0, pass, salt);
                        }
                        {
                            this.this$0 = var1_1;
                            super(2);
                        }
                    }), this.$erl, this.$outputFile);
                }
            }
            {
                this.this$0 = eCSymmetric;
                this.$password = string;
                this.$input = object;
                this.$erl = eCResultListener;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void encrypt$default(ECSymmetric eCSymmetric, Object object, String string, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 8) != 0) {
            file = new File(Constants.Companion.getDEF_ENCRYPTED_FILE_PATH());
        }
        eCSymmetric.encrypt(object, string, eCResultListener, file);
    }

    @JvmOverloads
    public final <T> void encrypt(@NotNull T input, @NotNull String password, @NotNull ECResultListener erl) {
        ECSymmetric.encrypt$default(this, input, password, erl, null, 8, null);
    }

    @JvmOverloads
    public final <T> void decrypt(@NotNull T input, @NotNull String password, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECSymmetric>, Unit>(this, password, input, erl, outputFile){
            final /* synthetic */ ECSymmetric this$0;
            final /* synthetic */ String $password;
            final /* synthetic */ Object $input;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ File $outputFile;

            public final void invoke(@NotNull AnkoAsyncContext<ECSymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Object object = this.$password;
                String string = object;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String tPass = ((Object)StringsKt.trim((CharSequence)string)).toString();
                object = this.$input;
                if (object instanceof String) {
                    try {
                        byte[] byArray = DataTypeExtensionsKt.fromBase64((String)this.$input);
                        ECSymmetric eCSymmetric = this.this$0;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        eCSymmetric.decrypt(byteArrayInputStream, this.$password, this.$erl, this.$outputFile);
                    }
                    catch (IllegalArgumentException e) {
                        this.$erl.onFailure("Invalid base64 string.", e);
                    }
                } else if (object instanceof CharSequence) {
                    try {
                        byte[] e = DataTypeExtensionsKt.fromBase64(this.$input.toString());
                        ECSymmetric eCSymmetric = this.this$0;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e);
                        eCSymmetric.decrypt(byteArrayInputStream, this.$password, this.$erl, this.$outputFile);
                    }
                    catch (IllegalArgumentException e) {
                        this.$erl.onFailure("Invalid base64 string.", e);
                    }
                } else if (object instanceof byte[]) {
                    byte[] e = (byte[])this.$input;
                    ECSymmetric eCSymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(e);
                    eCSymmetric.decrypt(byteArrayInputStream, this.$password, this.$erl, this.$outputFile);
                } else if (object instanceof File) {
                    File file;
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$erl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    if (Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_DECRYPTED_FILE_PATH())) {
                        String string2 = ((File)this.$input).getAbsoluteFile().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"input.absoluteFile.toString()");
                        file = new File(StringsKt.removeSuffix((String)string2, (CharSequence)".ecrypt"));
                    } else {
                        file = this.$outputFile;
                    }
                    File decryptedFile = file;
                    File file2 = (File)this.$input;
                    ECSymmetric eCSymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    eCSymmetric.decrypt(fileInputStream, this.$password, this.$erl, decryptedFile);
                } else {
                    Cipher cipher = ECSymmetric.access$getCipher$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"cipher");
                    performDecrypt.INSTANCE.invoke$easycrypt_release(this.$input, tPass, cipher, (Function2<? super String, ? super byte[], ? extends SecretKeySpec>)((Function2)new Function2<String, byte[], SecretKeySpec>(this){
                        final /* synthetic */ decrypt.1 this$0;

                        @NotNull
                        public final SecretKeySpec invoke(@NotNull String pass, @NotNull byte[] salt) {
                            Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
                            Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
                            return ECSymmetric.access$getKey(this.this$0.this$0, pass, salt);
                        }
                        {
                            this.this$0 = var1_1;
                            super(2);
                        }
                    }), this.$erl, this.$outputFile);
                }
            }
            {
                this.this$0 = eCSymmetric;
                this.$password = string;
                this.$input = object;
                this.$erl = eCResultListener;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void decrypt$default(ECSymmetric eCSymmetric, Object object, String string, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 8) != 0) {
            file = new File(Constants.Companion.getDEF_DECRYPTED_FILE_PATH());
        }
        eCSymmetric.decrypt(object, string, eCResultListener, file);
    }

    @JvmOverloads
    public final <T> void decrypt(@NotNull T input, @NotNull String password, @NotNull ECResultListener erl) {
        ECSymmetric.decrypt$default(this, input, password, erl, null, 8, null);
    }

    public ECSymmetric(@NotNull ECSymmetricTransformations transformation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)transformation), (String)"transformation");
        this.cipher = Cipher.getInstance(transformation.getValue());
        if (Build.VERSION.SDK_INT < 19) {
            PRNGFixes.apply();
        }
    }

    public /* synthetic */ ECSymmetric(ECSymmetricTransformations eCSymmetricTransformations, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eCSymmetricTransformations = ECSymmetricTransformations.AES_CBC_PKCS7Padding;
        }
        this(eCSymmetricTransformations);
    }

    public ECSymmetric() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Cipher access$getCipher$p(ECSymmetric $this) {
        return $this.cipher;
    }

    @NotNull
    public static final /* synthetic */ SecretKeySpec access$getKey(ECSymmetric $this, @NotNull String password, @NotNull byte[] salt) {
        return $this.getKey(password, salt);
    }
}

