/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.util;

import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.util.ArrayList;

public class SystemNativeCryptoLibrary
implements NativeCryptoLibrary {
    private static final ArrayList<String> LIBS = new ArrayList<String>(){
        {
            this.add("conceal");
        }
    };
    private boolean mLoadLibraries = true;
    private boolean mLibrariesLoaded = false;
    private volatile UnsatisfiedLinkError mLinkError = null;

    @Override
    public synchronized void ensureCryptoLoaded() throws CryptoInitializationException {
        if (!this.loadLibraries()) {
            throw new CryptoInitializationException(this.mLinkError);
        }
    }

    private synchronized boolean loadLibraries() {
        if (!this.mLoadLibraries) {
            return this.mLibrariesLoaded;
        }
        try {
            for (String name : LIBS) {
                System.loadLibrary(name);
            }
            this.mLibrariesLoaded = true;
        }
        catch (UnsatisfiedLinkError error) {
            this.mLinkError = error;
            this.mLibrariesLoaded = false;
        }
        this.mLoadLibraries = false;
        return this.mLibrariesLoaded;
    }
}

