/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.model;

import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.math.BigDecimal;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import milfont.com.tezosj_android.data.TezosNetwork;
import milfont.com.tezosj_android.domain.Crypto;
import milfont.com.tezosj_android.domain.Rpc;
import milfont.com.tezosj_android.helper.Base58;
import milfont.com.tezosj_android.helper.Constants;
import milfont.com.tezosj_android.helper.Global;
import milfont.com.tezosj_android.helper.KeyPair;
import milfont.com.tezosj_android.helper.Sha256Hash;
import milfont.com.tezosj_android.helper.SharedPreferencesHelper;
import milfont.com.tezosj_android.model.EncKeys;
import milfont.com.tezosj_android.model.Transaction;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.crypto.MnemonicCode;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;

public class TezosWallet {
    private String alias = "";
    private byte[] publicKey;
    private byte[] publicKeyHash;
    private byte[] privateKey;
    private byte[] mnemonicWords;
    private String balance = "";
    private ArrayList<Transaction> transactions = null;
    private String encPass;
    private String encIv;
    private Rpc rpc = null;
    private Crypto crypto = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TezosWallet(String passPhrase) throws Exception {
        if (passPhrase == null) throw new RuntimeException("Null passphrase.");
        if (passPhrase.length() <= 0) throw new RuntimeException("A passphrase is mandatory.");
        byte[] c = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            c[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(c);
        this.generateMnemonic();
        this.generateKeys(passPhrase);
        this.initDomainClasses();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TezosWallet(String passPhrase, @NotNull String pocketDevID, @NotNull TezosNetwork pocketNetID, int pocketTimeout) throws Exception {
        if (passPhrase == null) throw new RuntimeException("Null passphrase.");
        if (passPhrase.length() <= 0) throw new RuntimeException("A passphrase is mandatory.");
        byte[] c = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            c[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(c);
        this.generateMnemonic();
        this.generateKeys(passPhrase);
        this.initDomainClasses(pocketDevID, pocketNetID, pocketTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TezosWallet(String mnemonicWords, String passPhrase) throws Exception {
        if (mnemonicWords == null) throw new RuntimeException("Null mnemonic words.");
        if (mnemonicWords.length() <= 0) throw new RuntimeException("Mnemonic words are mandatory.");
        if (passPhrase == null) throw new RuntimeException("Null passphrase.");
        if (passPhrase.length() <= 0) throw new RuntimeException("A passphrase is mandatory.");
        byte[] c = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            c[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(c);
        String cleanMnemonic = mnemonicWords.replace("[", "");
        cleanMnemonic = cleanMnemonic.replace("]", "");
        cleanMnemonic = cleanMnemonic.replace(",", " ");
        cleanMnemonic = cleanMnemonic.replace("  ", " ");
        byte[] b = new byte[cleanMnemonic.length()];
        for (int i = 0; i < cleanMnemonic.length(); ++i) {
            b[i] = (byte)cleanMnemonic.charAt(i);
        }
        this.mnemonicWords = TezosWallet.encryptBytes(b, this.getEncryptionKey());
        this.generateKeys(passPhrase);
        this.initDomainClasses();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TezosWallet(String mnemonicWords, String passPhrase, @NotNull String pocketDevID, @NotNull TezosNetwork pocketNetID, int pocketTimeout) throws Exception {
        if (mnemonicWords == null) throw new RuntimeException("Null mnemonic words.");
        if (mnemonicWords.length() <= 0) throw new RuntimeException("Mnemonic words are mandatory.");
        if (passPhrase == null) throw new RuntimeException("Null passphrase.");
        if (passPhrase.length() <= 0) throw new RuntimeException("A passphrase is mandatory.");
        byte[] c = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            c[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(c);
        String cleanMnemonic = mnemonicWords.replace("[", "");
        cleanMnemonic = cleanMnemonic.replace("]", "");
        cleanMnemonic = cleanMnemonic.replace(",", " ");
        cleanMnemonic = cleanMnemonic.replace("  ", " ");
        byte[] b = new byte[cleanMnemonic.length()];
        for (int i = 0; i < cleanMnemonic.length(); ++i) {
            b[i] = (byte)cleanMnemonic.charAt(i);
        }
        this.mnemonicWords = TezosWallet.encryptBytes(b, this.getEncryptionKey());
        this.generateKeys(passPhrase);
        this.initDomainClasses(pocketDevID, pocketNetID, pocketTimeout);
    }

    public TezosWallet(String privateKey, String publicKey, String publicKeyHash, String passPhrase) throws Exception {
        this.resetWallet();
        this.alias = "";
        this.mnemonicWords = null;
        byte[] z = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            z[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(z);
        this.initDomainClasses();
        byte[] c = new byte[privateKey.length()];
        for (int i = 0; i < privateKey.length(); ++i) {
            c[i] = (byte)privateKey.charAt(i);
        }
        this.privateKey = TezosWallet.encryptBytes(c, this.getEncryptionKey());
        byte[] d = new byte[publicKey.length()];
        for (int i = 0; i < publicKey.length(); ++i) {
            d[i] = (byte)publicKey.charAt(i);
        }
        this.publicKey = TezosWallet.encryptBytes(d, this.getEncryptionKey());
        byte[] e = new byte[publicKeyHash.length()];
        for (int i = 0; i < publicKeyHash.length(); ++i) {
            e[i] = (byte)publicKeyHash.charAt(i);
        }
        this.publicKeyHash = TezosWallet.encryptBytes(e, this.getEncryptionKey());
    }

    public TezosWallet(Context ctx, String p) {
        this.load(ctx, p);
    }

    private void initDomainClasses() {
        this.rpc = new Rpc();
        this.crypto = new Crypto();
    }

    public TezosWallet(String privateKey, String publicKey, String publicKeyHash, String passPhrase, @NotNull String pocketDevID, @NotNull TezosNetwork pocketNetID, int pocketTimeout) throws Exception {
        this.resetWallet();
        this.alias = "";
        this.mnemonicWords = null;
        byte[] z = new byte[passPhrase.length()];
        for (int i = 0; i < passPhrase.length(); ++i) {
            z[i] = (byte)passPhrase.charAt(i);
        }
        this.initStore(z);
        this.initDomainClasses();
        this.initDomainClasses(pocketDevID, pocketNetID, pocketTimeout);
        byte[] c = new byte[privateKey.length()];
        for (int i = 0; i < privateKey.length(); ++i) {
            c[i] = (byte)privateKey.charAt(i);
        }
        this.privateKey = TezosWallet.encryptBytes(c, this.getEncryptionKey());
        byte[] d = new byte[publicKey.length()];
        for (int i = 0; i < publicKey.length(); ++i) {
            d[i] = (byte)publicKey.charAt(i);
        }
        this.publicKey = TezosWallet.encryptBytes(d, this.getEncryptionKey());
        byte[] e = new byte[publicKeyHash.length()];
        for (int i = 0; i < publicKeyHash.length(); ++i) {
            e[i] = (byte)publicKeyHash.charAt(i);
        }
        this.publicKeyHash = TezosWallet.encryptBytes(e, this.getEncryptionKey());
    }

    private void initDomainClasses(@NotNull String devID, @NotNull TezosNetwork netID, int timeout) {
        this.rpc = new Rpc(devID, netID, timeout);
        this.crypto = new Crypto();
    }

    private void generateKeys(String passphrase) throws Exception {
        byte[] input = TezosWallet.decryptBytes(this.mnemonicWords, this.getEncryptionKey());
        StringBuilder builder = new StringBuilder();
        for (byte anInput : input) {
            builder.append((char)anInput);
        }
        MnemonicCode mc = new MnemonicCode();
        List<String> items = Arrays.asList(builder.toString().split(" "));
        byte[] src_seed = MnemonicCode.toSeed(items, (String)passphrase);
        byte[] seed = Arrays.copyOfRange(src_seed, 0, 32);
        KeyPair key = new KeyPair(seed);
        byte[] sodiumPublicKey = key.getPublicKey().toBytes();
        byte[] sodiumPrivateKey = key.getPrivateKey().toBytes();
        byte[] edpkPrefix = new byte[]{13, 15, 37, -39};
        byte[] edskPrefix = new byte[]{43, -10, 78, 7};
        byte[] tz1Prefix = new byte[]{6, -95, -97};
        byte[] prefixedPubKey = new byte[36];
        System.arraycopy(edpkPrefix, 0, prefixedPubKey, 0, 4);
        System.arraycopy(sodiumPublicKey, 0, prefixedPubKey, 4, 32);
        byte[] firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedPubKey);
        byte[] prefixedPubKeyWithChecksum = new byte[40];
        System.arraycopy(prefixedPubKey, 0, prefixedPubKeyWithChecksum, 0, 36);
        System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedPubKeyWithChecksum, 36, 4);
        this.publicKey = TezosWallet.encryptBytes(Base58.encode(prefixedPubKeyWithChecksum).getBytes(), this.getEncryptionKey());
        byte[] prefixedSecKey = new byte[68];
        System.arraycopy(edskPrefix, 0, prefixedSecKey, 0, 4);
        System.arraycopy(sodiumPrivateKey, 0, prefixedSecKey, 4, 64);
        firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedSecKey);
        byte[] prefixedSecKeyWithChecksum = new byte[72];
        System.arraycopy(prefixedSecKey, 0, prefixedSecKeyWithChecksum, 0, 68);
        System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedSecKeyWithChecksum, 68, 4);
        this.privateKey = TezosWallet.encryptBytes(Base58.encode(prefixedSecKeyWithChecksum).getBytes(), this.getEncryptionKey());
        byte[] genericHash = new byte[20];
        NaCl.sodium();
        int r = Sodium.crypto_generichash(genericHash, genericHash.length, sodiumPublicKey, sodiumPublicKey.length, sodiumPublicKey, 0);
        byte[] prefixedGenericHash = new byte[23];
        System.arraycopy(tz1Prefix, 0, prefixedGenericHash, 0, 3);
        System.arraycopy(genericHash, 0, prefixedGenericHash, 3, 20);
        firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedGenericHash);
        byte[] prefixedPKhashWithChecksum = new byte[27];
        System.arraycopy(prefixedGenericHash, 0, prefixedPKhashWithChecksum, 0, 23);
        System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedPKhashWithChecksum, 23, 4);
        String pkHash = Base58.encode(prefixedPKhashWithChecksum);
        this.publicKeyHash = TezosWallet.encryptBytes(Base58.encode(prefixedPKhashWithChecksum).getBytes(), this.getEncryptionKey());
    }

    private void generateMnemonic() throws Exception {
        String result = "";
        MnemonicCode mc = new MnemonicCode();
        byte[] bytes = new byte[20];
        new Random().nextBytes(bytes);
        ArrayList code = (ArrayList)mc.toMnemonic(bytes);
        result = code.toString();
        String strMessage = "";
        strMessage = code.toString();
        String cleanMnemonic = strMessage.replace("[", "");
        cleanMnemonic = cleanMnemonic.replace("]", "");
        cleanMnemonic = cleanMnemonic.replace(",", " ");
        cleanMnemonic = cleanMnemonic.replace("  ", " ");
        byte[] b = new byte[cleanMnemonic.length()];
        for (int i = 0; i < cleanMnemonic.length(); ++i) {
            b[i] = (byte)cleanMnemonic.charAt(i);
        }
        this.mnemonicWords = TezosWallet.encryptBytes(b, this.getEncryptionKey());
    }

    private static byte[] encryptBytes(byte[] original, byte[] key) {
        try {
            SecretKeySpec keySpec = null;
            Cipher cipher = null;
            keySpec = new SecretKeySpec(key, "AES/ECB/PKCS7Padding");
            cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(1, keySpec);
            return cipher.doFinal(original);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] decryptBytes(byte[] encrypted, byte[] key) {
        try {
            SecretKeySpec keySpec = null;
            Cipher cipher = null;
            keySpec = new SecretKeySpec(key, "AES/ECB/PKCS7Padding");
            cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(2, keySpec);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMnemonicWords() {
        byte[] decrypted = TezosWallet.decryptBytes(this.mnemonicWords, this.getEncryptionKey());
        StringBuilder builder = new StringBuilder();
        for (byte aDecrypted : decrypted) {
            builder.append((char)aDecrypted);
        }
        return builder.toString();
    }

    public String getPublicKeyHash() {
        if (this.publicKeyHash != null) {
            if (this.publicKeyHash.length > 0) {
                byte[] decrypted = TezosWallet.decryptBytes(this.publicKeyHash, this.getEncryptionKey());
                StringBuilder builder = new StringBuilder();
                for (byte aDecrypted : decrypted) {
                    builder.append((char)aDecrypted);
                }
                return builder.toString();
            }
            throw new RuntimeException("Error getting public key hash.");
        }
        throw new RuntimeException("Error getting public key hash.");
    }

    public String getBalance() throws Exception {
        if (this.publicKeyHash != null) {
            if (this.publicKeyHash.length > 0) {
                if (this.crypto.checkAddress(this.getPublicKeyHash()).booleanValue()) {
                    BigDecimal tezBalance = new BigDecimal(String.valueOf(BigDecimal.ZERO));
                    byte[] decrypted = TezosWallet.decryptBytes(this.publicKeyHash, this.getEncryptionKey());
                    StringBuilder builder = new StringBuilder();
                    for (byte aDecrypted : decrypted) {
                        builder.append((char)aDecrypted);
                    }
                    String strBalance = (String)this.rpc.getBalance(builder.toString()).get("result");
                    if (StringUtils.isNumeric((CharSequence)strBalance.replaceAll("[^\\d.]", ""))) {
                        if (Long.parseLong(strBalance.replaceAll("[^\\d.]", "")) > 0L) {
                            tezBalance = new BigDecimal(strBalance.replaceAll("[^\\d.]", "")).divide(BigDecimal.valueOf(Constants.UTEZ.intValue()));
                        }
                    } else {
                        throw new RuntimeException(strBalance);
                    }
                    this.balance = String.valueOf(tezBalance) + " " + "\ua729";
                    return this.balance;
                }
                throw new RuntimeException("Invalid address.");
            }
            throw new RuntimeException("A valid Tezos address is mandatory.");
        }
        throw new RuntimeException("No wallet found to get balance from.");
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String newAlias) {
        this.alias = newAlias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject send(String from, String to, BigDecimal amount, BigDecimal fee, String gasLimit, String storageLimit, JSONObject parameters) throws Exception {
        JSONObject result = new JSONObject();
        if (from == null) throw new RuntimeException("The fields: From, To and Amount are required.");
        if (to == null) throw new RuntimeException("The fields: From, To and Amount are required.");
        if (amount == null) throw new RuntimeException("The fields: From, To and Amount are required.");
        if (this.crypto.checkAddress(from) != true) throw new RuntimeException("Valid Tezos addresses are required in From and To fields.");
        if (this.crypto.checkAddress(to) != true) throw new RuntimeException("Valid Tezos addresses are required in From and To fields.");
        if (from.length() <= 0) throw new RuntimeException("Sender (From field) is mandatory.");
        if (to.length() <= 0) throw new RuntimeException("Recipient (To field) is mandatory.");
        if (amount.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Amount must be greater than zero.");
        if (fee.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Fee must be greater than zero.");
        EncKeys encKeys = new EncKeys(this.publicKey, this.privateKey, this.publicKeyHash);
        encKeys.setEncIv(this.encIv);
        encKeys.setEncP(this.encPass);
        return this.rpc.transfer(from, to, amount, fee, gasLimit, storageLimit, encKeys, parameters);
    }

    private void initStore(byte[] toHash) {
        try {
            String pString = new String(toHash, "UTF-8");
            int hashedP = pString.hashCode();
            String strHash = String.valueOf(hashedP);
            while (strHash.length() < 16) {
                strHash = strHash + strHash;
            }
            pString = strHash = strHash.substring(0, 16);
            SecretKey secretKey = this.createKey();
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(1, secretKey);
            byte[] encryptionIv = cipher.getIV();
            byte[] pBytes = pString.getBytes("UTF-8");
            byte[] encPBytes = cipher.doFinal(pBytes);
            String encP = Base64.encodeToString((byte[])encPBytes, (int)0);
            String encryptedIv = Base64.encodeToString((byte[])encryptionIv, (int)0);
            this.encPass = encP;
            this.encIv = encryptedIv;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Android KeyStore.", e);
        }
    }

    private SecretKey createKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder("tzj", 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationValidityDurationSeconds(5).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build());
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a symetric key", e);
        }
    }

    private byte[] getEncryptionKey() {
        try {
            String base64EncryptedPassword = this.encPass;
            String base64EncryptionIv = this.encIv;
            byte[] encryptionIv = Base64.decode((String)base64EncryptionIv, (int)0);
            byte[] encryptionPassword = Base64.decode((String)base64EncryptedPassword, (int)0);
            KeyStore keystore = KeyStore.getInstance("AndroidKeyStore");
            keystore.load(null);
            SecretKey secretKey = (SecretKey)keystore.getKey("tzj", null);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptionIv));
            byte[] passwordBytes = cipher.doFinal(encryptionPassword);
            String password = new String(passwordBytes, "UTF-8");
            return passwordBytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getEncryptionKey(EncKeys keys) {
        try {
            String base64EncryptedPassword = keys.getEncP();
            String base64EncryptionIv = keys.getEncIv();
            byte[] encryptionIv = Base64.decode((String)base64EncryptionIv, (int)0);
            byte[] encryptionPassword = Base64.decode((String)base64EncryptedPassword, (int)0);
            KeyStore keystore = KeyStore.getInstance("AndroidKeyStore");
            keystore.load(null);
            SecretKey secretKey = (SecretKey)keystore.getKey("tzj", null);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptionIv));
            byte[] passwordBytes = cipher.doFinal(encryptionPassword);
            String password = new String(passwordBytes, "UTF-8");
            return passwordBytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void save(Context ctx) {
        try {
            String myWalletData = Base64.encodeToString((byte[])this.alias.getBytes(), (int)0) + ";" + Base64.encodeToString((byte[])this.publicKey, (int)0) + ";" + Base64.encodeToString((byte[])this.publicKeyHash, (int)0) + ";" + Base64.encodeToString((byte[])this.privateKey, (int)0) + ";" + Base64.encodeToString((byte[])this.balance.getBytes(), (int)0) + ";" + Base64.encodeToString((byte[])this.mnemonicWords, (int)0) + ";";
            SharedPreferencesHelper sp = new SharedPreferencesHelper();
            sp.setSharedPreferenceString(ctx, "tzj", myWalletData);
            Boolean result = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error when trying to save the wallet to media.");
        }
    }

    public void load(Context ctx, String p) {
        try {
            String myWalletString = "";
            SharedPreferencesHelper sp = new SharedPreferencesHelper();
            myWalletString = sp.getSharedPreferenceString(ctx, "tzj", "");
            if (myWalletString.length() > 0) {
                this.resetWallet();
                String[] fields = myWalletString.split("\\;", -1);
                this.alias = new String(Base64.decode((String)fields[0], (int)0), "UTF-8");
                this.publicKey = Base64.decode((String)fields[1], (int)0);
                this.publicKeyHash = Base64.decode((String)fields[2], (int)0);
                this.privateKey = Base64.decode((String)fields[3], (int)0);
                this.balance = new String(Base64.decode((String)fields[4], (int)0), "UTF-8");
                this.mnemonicWords = Base64.decode((String)fields[5], (int)0);
                byte[] c = new byte[p.length()];
                for (int i = 0; i < p.length(); ++i) {
                    c[i] = (byte)p.charAt(i);
                }
                this.initStore(c);
                this.initDomainClasses();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when trying to load wallet from media.");
        }
    }

    private String buildStringFromByte(byte[] input) {
        StringBuilder builder = new StringBuilder();
        for (byte anInput : input) {
            builder.append((char)anInput);
        }
        return builder.toString();
    }

    private byte[] buildByteFromString(String input) {
        byte[] d = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            d[i] = (byte)input.charAt(i);
        }
        return d;
    }

    private void resetWallet() {
        this.privateKey = null;
        this.mnemonicWords = null;
        this.encPass = null;
        this.encIv = null;
        this.publicKeyHash = null;
        this.publicKey = null;
        this.balance = "";
        this.transactions = null;
        this.rpc = null;
    }

    public Boolean checkPhrase(String phrase) {
        Boolean result;
        try {
            byte[] input;
            MnemonicCode mc = new MnemonicCode();
            List<String> items = Arrays.asList(this.getMnemonicWords().split(" "));
            byte[] src_seed = MnemonicCode.toSeed(items, (String)phrase);
            byte[] seed = Arrays.copyOfRange(src_seed, 0, 32);
            KeyPair key = new KeyPair(seed);
            byte[] sodiumPublicKey = key.getPublicKey().toBytes();
            byte[] sodiumPrivateKey = key.getPrivateKey().toBytes();
            byte[] edpkPrefix = new byte[]{13, 15, 37, -39};
            byte[] prefixedPubKey = new byte[36];
            System.arraycopy(edpkPrefix, 0, prefixedPubKey, 0, 4);
            System.arraycopy(sodiumPublicKey, 0, prefixedPubKey, 4, 32);
            byte[] firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedPubKey);
            byte[] prefixedPubKeyWithChecksum = new byte[40];
            System.arraycopy(prefixedPubKey, 0, prefixedPubKeyWithChecksum, 0, 36);
            System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedPubKeyWithChecksum, 36, 4);
            String publicKey = Base58.encode(prefixedPubKeyWithChecksum);
            StringBuilder builder = new StringBuilder();
            for (byte anInput : input = TezosWallet.decryptBytes(this.publicKey, this.getEncryptionKey())) {
                builder.append((char)anInput);
            }
            result = publicKey.equals(builder.toString()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void setProxy(String proxyHost, String proxyPort) {
        Global.proxyHost = proxyHost;
        Global.proxyPort = proxyPort;
    }

    public void setIgnoreInvalidCertificates(Boolean ignore) {
        Global.ignoreInvalidCertificates = ignore;
    }

    public void setProvider(String provider) {
        Global.defaultProvider = provider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject delegate(String delegateFrom, String delegateTo, BigDecimal fee, String gasLimit, String storageLimit) throws Exception {
        JSONObject result = new JSONObject();
        if (delegateFrom == null) throw new RuntimeException("The fields: delegateFrom, delegateTo are required.");
        if (delegateTo == null) throw new RuntimeException("The fields: delegateFrom, delegateTo are required.");
        if (this.crypto.checkAddress(delegateFrom) != true) throw new RuntimeException("Valid Tezos addresses are required in delegateFrom and delegateTo fields.");
        if (this.crypto.checkAddress(delegateTo) != true) throw new RuntimeException("Valid Tezos addresses are required in delegateFrom and delegateTo fields.");
        if (delegateFrom.length() <= 0) throw new RuntimeException("Delegator (delegateFrom field) is mandatory.");
        if (delegateTo.length() <= 0) throw new RuntimeException("Delegate (delegateTo field) is mandatory.");
        if (fee.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Fee must be greater than zero.");
        EncKeys encKeys = new EncKeys(this.publicKey, this.privateKey, this.publicKeyHash);
        encKeys.setEncIv(this.encIv);
        encKeys.setEncP(this.encPass);
        return this.rpc.delegate(delegateFrom, delegateTo, fee, gasLimit, storageLimit, encKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject originate(String from, Boolean spendable, Boolean delegatable, BigDecimal fee, String gasLimit, String storageLimit, BigDecimal amount, String code, String storage) throws Exception {
        JSONObject result = new JSONObject();
        if (from == null) throw new RuntimeException("The field: delegate is required.");
        if (this.crypto.checkAddress(from) != true) throw new RuntimeException("Valid Tezos address is required in delegate field.");
        if (from.length() <= 0) throw new RuntimeException("Delegator (delegateFrom field) is mandatory.");
        if (fee.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Fee must be greater than zero.");
        EncKeys encKeys = new EncKeys(this.publicKey, this.privateKey, this.publicKeyHash);
        encKeys.setEncIv(this.encIv);
        encKeys.setEncP(this.encPass);
        return this.rpc.originate(from, spendable, delegatable, fee, gasLimit, storageLimit, amount, code, storage, encKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject undelegate(String delegateFrom, BigDecimal fee) throws Exception {
        JSONObject result = new JSONObject();
        if (delegateFrom == null) throw new RuntimeException("The field: delegateFrom is required.");
        if (this.crypto.checkAddress(delegateFrom) != true) throw new RuntimeException("Valid Tezos address is required in delegateFrom field.");
        if (delegateFrom.length() <= 0) throw new RuntimeException("Delegator (delegateFrom field) is mandatory.");
        if (fee.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Fee must be greater than zero.");
        EncKeys encKeys = new EncKeys(this.publicKey, this.privateKey, this.publicKeyHash);
        encKeys.setEncIv(this.encIv);
        encKeys.setEncP(this.encPass);
        return this.rpc.undelegate(delegateFrom, fee, encKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject callContractEntryPoint(String from, String contract, BigDecimal amount, BigDecimal fee, String gasLimit, String storageLimit, String entrypoint, String[] parameters) throws Exception {
        JSONObject result = new JSONObject();
        if (from == null) throw new RuntimeException("The fields: From, Contract, Amount, Entrypoint and Parameters are required.");
        if (contract == null) throw new RuntimeException("The fields: From, Contract, Amount, Entrypoint and Parameters are required.");
        if (amount == null) throw new RuntimeException("The fields: From, Contract, Amount, Entrypoint and Parameters are required.");
        if (entrypoint == null) throw new RuntimeException("The fields: From, Contract, Amount, Entrypoint and Parameters are required.");
        if (parameters == null) throw new RuntimeException("The fields: From, Contract, Amount, Entrypoint and Parameters are required.");
        if (this.crypto.checkAddress(from) != true) throw new RuntimeException("Valid Tezos addresses are required in From and To fields.");
        if (this.crypto.checkAddress(contract) != true) throw new RuntimeException("Valid Tezos addresses are required in From and To fields.");
        if (from.length() <= 0) throw new RuntimeException("Sender (From field) is mandatory.");
        if (contract.length() <= 0) throw new RuntimeException("Contract field is mandatory.");
        if (amount.compareTo(BigDecimal.ZERO) < 0) throw new RuntimeException("Amount must be greater than or equal to zero.");
        if (fee.compareTo(BigDecimal.ZERO) <= 0) throw new RuntimeException("Fee must be greater than zero.");
        EncKeys encKeys = new EncKeys(this.publicKey, this.privateKey, this.publicKeyHash);
        encKeys.setEncIv(this.encIv);
        encKeys.setEncP(this.encPass);
        return this.rpc.callContractEntryPoint(from, contract, amount, fee, gasLimit, storageLimit, encKeys, entrypoint, parameters);
    }
}

