/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto;

import com.facebook.crypto.CheckedKeyChain;
import com.facebook.crypto.CryptoAlgo;
import com.facebook.crypto.CryptoAlgoGcm;
import com.facebook.crypto.CryptoConfig;
import com.facebook.crypto.Entity;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.mac.NativeMac;
import com.facebook.crypto.streams.FixedSizeByteArrayOutputStream;
import com.facebook.crypto.streams.NativeMacLayeredInputStream;
import com.facebook.crypto.streams.NativeMacLayeredOutputStream;
import com.facebook.crypto.util.Assertions;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Crypto {
    private final KeyChain mKeyChain;
    private final NativeCryptoLibrary mNativeCryptoLibrary;
    private final CryptoAlgo mCryptoAlgo;

    @Deprecated
    public Crypto(KeyChain keyChain, NativeCryptoLibrary nativeCryptoLibrary) {
        this(keyChain, nativeCryptoLibrary, CryptoConfig.KEY_128);
    }

    public Crypto(KeyChain keyChain, NativeCryptoLibrary nativeCryptoLibrary, CryptoConfig config) {
        this.mKeyChain = new CheckedKeyChain(keyChain, config);
        this.mNativeCryptoLibrary = nativeCryptoLibrary;
        this.mCryptoAlgo = new CryptoAlgoGcm(this.mNativeCryptoLibrary, this.mKeyChain, config);
    }

    public boolean isAvailable() {
        try {
            this.mNativeCryptoLibrary.ensureCryptoLoaded();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public OutputStream getCipherOutputStream(OutputStream cipherStream, Entity entity) throws IOException, CryptoInitializationException, KeyChainException {
        return this.getCipherOutputStream(cipherStream, entity, null);
    }

    public OutputStream getCipherOutputStream(OutputStream cipherStream, Entity entity, byte[] encryptBuffer) throws IOException, CryptoInitializationException, KeyChainException {
        return this.mCryptoAlgo.wrap(cipherStream, entity, encryptBuffer);
    }

    public InputStream getCipherInputStream(InputStream cipherStream, Entity entity) throws IOException, CryptoInitializationException, KeyChainException {
        return this.mCryptoAlgo.wrap(cipherStream, entity);
    }

    public byte[] encrypt(byte[] plainTextBytes, Entity entity) throws KeyChainException, CryptoInitializationException, IOException {
        int cipheredBytesLength = plainTextBytes.length + this.getCipherMetaDataLength();
        FixedSizeByteArrayOutputStream outputStream = new FixedSizeByteArrayOutputStream(cipheredBytesLength);
        OutputStream cipherStream = this.getCipherOutputStream(outputStream, entity, null);
        cipherStream.write(plainTextBytes);
        cipherStream.close();
        return outputStream.getBytes();
    }

    public byte[] decrypt(byte[] cipherTextBytes, Entity entity) throws KeyChainException, CryptoInitializationException, IOException {
        int read;
        int cipherTextLength = cipherTextBytes.length;
        ByteArrayInputStream cipheredStream = new ByteArrayInputStream(cipherTextBytes);
        InputStream plainTextStream = this.getCipherInputStream(cipheredStream, entity);
        int plainTextLength = cipherTextLength - this.getCipherMetaDataLength();
        FixedSizeByteArrayOutputStream output = new FixedSizeByteArrayOutputStream(plainTextLength);
        byte[] buffer = new byte[1024];
        while ((read = plainTextStream.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        plainTextStream.close();
        return output.getBytes();
    }

    public OutputStream getMacOutputStream(OutputStream stream, Entity entity) throws IOException, KeyChainException, CryptoInitializationException {
        stream.write(1);
        stream.write(1);
        NativeMac nativeMac = new NativeMac(this.mNativeCryptoLibrary);
        byte[] macKey = this.mKeyChain.getMacKey();
        nativeMac.init(macKey, macKey.length);
        byte[] entityBytes = entity.getBytes();
        Crypto.computeMacAad(nativeMac, (byte)1, (byte)1, entityBytes);
        return new NativeMacLayeredOutputStream(nativeMac, stream);
    }

    public InputStream getMacInputStream(InputStream stream, Entity entity) throws IOException, KeyChainException, CryptoInitializationException {
        byte macVersion = (byte)stream.read();
        Assertions.checkArgumentForIO(macVersion == 1, "Unexpected mac version " + macVersion);
        byte macID = (byte)stream.read();
        Assertions.checkArgumentForIO(macID == 1, "Unexpected mac ID " + macID);
        NativeMac nativeMac = new NativeMac(this.mNativeCryptoLibrary);
        byte[] macKey = this.mKeyChain.getMacKey();
        nativeMac.init(macKey, macKey.length);
        byte[] entityBytes = entity.getBytes();
        Crypto.computeMacAad(nativeMac, macVersion, (byte)1, entityBytes);
        return new NativeMacLayeredInputStream(nativeMac, stream);
    }

    private static void computeMacAad(NativeMac mac, byte macVersion, byte macID, byte[] entityBytes) throws IOException {
        byte[] cryptoVersionBytes = new byte[]{macVersion};
        byte[] macIDBytes = new byte[]{macID};
        mac.update(cryptoVersionBytes, 0, 1);
        mac.update(macIDBytes, 0, 1);
        mac.update(entityBytes, 0, entityBytes.length);
    }

    int getCipherMetaDataLength() {
        return this.mCryptoAlgo.getCipherMetaDataLength();
    }
}

