/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.android.crypto.keychain;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.facebook.android.crypto.keychain.FixedSecureRandom;
import com.facebook.crypto.CryptoConfig;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import java.util.Arrays;

public class SharedPrefsBackedKeyChain
implements KeyChain {
    static final String SHARED_PREF_NAME = "crypto";
    static final String CIPHER_KEY_PREF = "cipher_key";
    static final String MAC_KEY_PREF = "mac_key";
    private final CryptoConfig mCryptoConfig;
    private final SharedPreferences mSharedPreferences;
    private final FixedSecureRandom mSecureRandom;
    protected byte[] mCipherKey;
    protected boolean mSetCipherKey;
    protected byte[] mMacKey;
    protected boolean mSetMacKey;

    @Deprecated
    public SharedPrefsBackedKeyChain(Context context) {
        this(context, CryptoConfig.KEY_128);
    }

    public SharedPrefsBackedKeyChain(Context context, CryptoConfig config) {
        String prefName = SharedPrefsBackedKeyChain.prefNameForConfig(config);
        this.mSharedPreferences = context.getSharedPreferences(prefName, 0);
        this.mSecureRandom = new FixedSecureRandom();
        this.mCryptoConfig = config;
    }

    private static String prefNameForConfig(CryptoConfig config) {
        return config == CryptoConfig.KEY_128 ? SHARED_PREF_NAME : "crypto." + String.valueOf((Object)config);
    }

    @Override
    public synchronized byte[] getCipherKey() throws KeyChainException {
        if (!this.mSetCipherKey) {
            this.mCipherKey = this.maybeGenerateKey(CIPHER_KEY_PREF, this.mCryptoConfig.keyLength);
        }
        this.mSetCipherKey = true;
        return this.mCipherKey;
    }

    @Override
    public byte[] getMacKey() throws KeyChainException {
        if (!this.mSetMacKey) {
            this.mMacKey = this.maybeGenerateKey(MAC_KEY_PREF, 64);
        }
        this.mSetMacKey = true;
        return this.mMacKey;
    }

    @Override
    public byte[] getNewIV() throws KeyChainException {
        byte[] iv = new byte[this.mCryptoConfig.ivLength];
        this.mSecureRandom.nextBytes(iv);
        return iv;
    }

    @Override
    public synchronized void destroyKeys() {
        this.mSetCipherKey = false;
        this.mSetMacKey = false;
        if (this.mCipherKey != null) {
            Arrays.fill(this.mCipherKey, (byte)0);
        }
        if (this.mMacKey != null) {
            Arrays.fill(this.mMacKey, (byte)0);
        }
        this.mCipherKey = null;
        this.mMacKey = null;
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(CIPHER_KEY_PREF);
        editor.remove(MAC_KEY_PREF);
        editor.commit();
    }

    private byte[] maybeGenerateKey(String pref, int length) throws KeyChainException {
        String base64Key = this.mSharedPreferences.getString(pref, null);
        if (base64Key == null) {
            return this.generateAndSaveKey(pref, length);
        }
        return this.decodeFromPrefs(base64Key);
    }

    private byte[] generateAndSaveKey(String pref, int length) throws KeyChainException {
        byte[] key = new byte[length];
        this.mSecureRandom.nextBytes(key);
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(pref, this.encodeForPrefs(key));
        editor.commit();
        return key;
    }

    byte[] decodeFromPrefs(String keyString) {
        if (keyString == null) {
            return null;
        }
        return Base64.decode((String)keyString, (int)0);
    }

    String encodeForPrefs(byte[] key) {
        if (key == null) {
            return null;
        }
        return Base64.encodeToString((byte[])key, (int)0);
    }
}

