/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorStreamCipher;
import com.subgraph.orchid.data.HexDigest;

public class CircuitNodeCryptoState {
    public static final int KEY_MATERIAL_SIZE = 72;
    private final HexDigest checksumDigest;
    private final TorMessageDigest forwardDigest;
    private final TorMessageDigest backwardDigest;
    private final TorStreamCipher forwardCipher;
    private final TorStreamCipher backwardCipher;

    public static CircuitNodeCryptoState createFromKeyMaterial(byte[] keyMaterial, byte[] verifyDigest) {
        return new CircuitNodeCryptoState(keyMaterial, verifyDigest);
    }

    private static byte[] extractDigestBytes(byte[] keyMaterial, int offset) {
        byte[] digestBytes = new byte[20];
        System.arraycopy(keyMaterial, offset, digestBytes, 0, 20);
        return digestBytes;
    }

    private static byte[] extractCipherKey(byte[] keyMaterial, int offset) {
        byte[] keyBytes = new byte[16];
        System.arraycopy(keyMaterial, offset, keyBytes, 0, 16);
        return keyBytes;
    }

    private CircuitNodeCryptoState(byte[] keyMaterial, byte[] verifyDigest) {
        this.checksumDigest = HexDigest.createFromDigestBytes(verifyDigest);
        int offset = 0;
        this.forwardDigest = new TorMessageDigest();
        this.forwardDigest.update(CircuitNodeCryptoState.extractDigestBytes(keyMaterial, offset));
        this.backwardDigest = new TorMessageDigest();
        this.backwardDigest.update(CircuitNodeCryptoState.extractDigestBytes(keyMaterial, offset += 20));
        this.forwardCipher = TorStreamCipher.createFromKeyBytes(CircuitNodeCryptoState.extractCipherKey(keyMaterial, offset += 20));
        this.backwardCipher = TorStreamCipher.createFromKeyBytes(CircuitNodeCryptoState.extractCipherKey(keyMaterial, offset += 16));
    }

    boolean verifyPacketDigest(HexDigest packetDigest) {
        return this.checksumDigest.equals(packetDigest);
    }

    void encryptForwardCell(Cell cell) {
        this.forwardCipher.encrypt(cell.getCellBytes(), 3, 509);
    }

    boolean decryptBackwardCell(Cell cell) {
        this.backwardCipher.encrypt(cell.getCellBytes(), 3, 509);
        return this.isRecognizedCell(cell);
    }

    void updateForwardDigest(Cell cell) {
        this.forwardDigest.update(cell.getCellBytes(), 3, 509);
    }

    byte[] getForwardDigestBytes() {
        return this.forwardDigest.getDigestBytes();
    }

    private boolean isRecognizedCell(Cell cell) {
        if (cell.getShortAt(4) != 0) {
            return false;
        }
        byte[] digest = this.extractRelayDigest(cell);
        byte[] peek = this.backwardDigest.peekDigest(cell.getCellBytes(), 3, 509);
        for (int i = 0; i < 4; ++i) {
            if (digest[i] == peek[i]) continue;
            this.replaceRelayDigest(cell, digest);
            return false;
        }
        this.backwardDigest.update(cell.getCellBytes(), 3, 509);
        this.replaceRelayDigest(cell, digest);
        return true;
    }

    private byte[] extractRelayDigest(Cell cell) {
        byte[] digest = new byte[4];
        for (int i = 0; i < 4; ++i) {
            digest[i] = (byte)cell.getByteAt(i + 8);
            cell.putByteAt(i + 8, 0);
        }
        return digest;
    }

    private void replaceRelayDigest(Cell cell, byte[] digest) {
        for (int i = 0; i < 4; ++i) {
            cell.putByteAt(i + 8, digest[i] & 0xFF);
        }
    }
}

