/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data;

import com.subgraph.orchid.TorException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RandomSet<E> {
    private final Set<E> set = new HashSet();
    private final List<E> list = new ArrayList();
    private final SecureRandom random = RandomSet.createRandom();

    private static SecureRandom createRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TorException(e);
        }
    }

    public boolean add(E o) {
        if (this.set.add(o)) {
            this.list.add(o);
            return true;
        }
        return false;
    }

    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.list.remove(o);
            return true;
        }
        return false;
    }

    public int size() {
        return this.set.size();
    }

    public E getRandomElement() {
        int idx = this.random.nextInt(this.list.size());
        return this.list.get(idx);
    }
}

