/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.path.BandwidthWeightedRouters;
import com.subgraph.orchid.circuits.path.CircuitNodeChooserWeightParameters;
import com.subgraph.orchid.circuits.path.RouterFilter;
import com.subgraph.orchid.circuits.path.TorConfigNodeFilter;
import com.subgraph.orchid.crypto.TorRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CircuitNodeChooser {
    private static final Logger logger = Logger.getLogger(CircuitNodeChooser.class.getName());
    private final Directory directory;
    private final TorRandom random = new TorRandom();
    private final TorConfigNodeFilter configNodeFilter;
    private static final double EPSILON = 0.1;

    public CircuitNodeChooser(TorConfig config, Directory directory) {
        this.directory = directory;
        this.configNodeFilter = new TorConfigNodeFilter(config);
    }

    public Router chooseExitNode(List<Router> candidates) {
        List<Router> filteredCandidates = this.configNodeFilter.filterExitCandidates(candidates);
        return this.chooseByBandwidth(filteredCandidates, WeightRule.WEIGHT_FOR_EXIT);
    }

    public Router chooseDirectory() {
        RouterFilter filter = new RouterFilter(){

            @Override
            public boolean filter(Router router) {
                return router.getDirectoryPort() != 0;
            }
        };
        List<Router> candidates = this.getFilteredRouters(filter, false);
        Router choice = this.chooseByBandwidth(candidates, WeightRule.WEIGHT_FOR_DIR);
        if (choice == null) {
            return this.directory.getRandomDirectoryAuthority();
        }
        return choice;
    }

    public Router chooseRandomNode(WeightRule rule, RouterFilter routerFilter) {
        List<Router> candidates = this.getFilteredRouters(routerFilter, true);
        Router choice = this.chooseByBandwidth(candidates, rule);
        if (choice == null) {
            return null;
        }
        return choice;
    }

    private List<Router> getFilteredRouters(RouterFilter rf, boolean needDescriptor) {
        ArrayList<Router> routers = new ArrayList<Router>();
        for (Router r : this.getUsableRouters(needDescriptor)) {
            if (!rf.filter(r)) continue;
            routers.add(r);
        }
        return routers;
    }

    List<Router> getUsableRouters(boolean needDescriptor) {
        ArrayList<Router> routers = new ArrayList<Router>();
        for (Router r : this.directory.getAllRouters()) {
            if (!r.isRunning() || !r.isValid() || r.isHibernating() || needDescriptor && r.getCurrentDescriptor() == null) continue;
            routers.add(r);
        }
        return routers;
    }

    private Router chooseByBandwidth(List<Router> candidates, WeightRule rule) {
        Router choice = this.chooseNodeByBandwidthWeights(candidates, rule);
        if (choice != null) {
            return choice;
        }
        return this.chooseNodeByBandwidth(candidates, rule);
    }

    private Router chooseNodeByBandwidthWeights(List<Router> candidates, WeightRule rule) {
        ConsensusDocument consensus = this.directory.getCurrentConsensusDocument();
        if (consensus == null) {
            return null;
        }
        BandwidthWeightedRouters bwr = this.computeWeightedBandwidths(candidates, consensus, rule);
        return bwr.chooseRandomRouterByWeight();
    }

    private BandwidthWeightedRouters computeWeightedBandwidths(List<Router> candidates, ConsensusDocument consensus, WeightRule rule) {
        CircuitNodeChooserWeightParameters wp = CircuitNodeChooserWeightParameters.create(consensus, rule);
        if (!wp.isValid()) {
            logger.warning("Got invalid bandwidth weights. Falling back to old selection method");
            return null;
        }
        BandwidthWeightedRouters weightedRouters = new BandwidthWeightedRouters();
        for (Router r : candidates) {
            double wbw = wp.calculateWeightedBandwidth(r);
            weightedRouters.addRouter(r, wbw);
        }
        return weightedRouters;
    }

    private Router chooseNodeByBandwidth(List<Router> routers, WeightRule rule) {
        BandwidthWeightedRouters bwr = new BandwidthWeightedRouters();
        for (Router r : routers) {
            long bw = this.getRouterBandwidthBytes(r);
            if (bw == -1L) {
                bwr.addRouterUnknown(r);
                continue;
            }
            bwr.addRouter(r, bw);
        }
        bwr.fixUnknownValues();
        if (bwr.isTotalBandwidthZero()) {
            if (routers.size() == 0) {
                return null;
            }
            int idx = this.random.nextInt(routers.size());
            return routers.get(idx);
        }
        this.computeFinalWeights(bwr, rule);
        return bwr.chooseRandomRouterByWeight();
    }

    private void computeFinalWeights(BandwidthWeightedRouters bwr, WeightRule rule) {
        double exitWeight = this.calculateWeight(rule == WeightRule.WEIGHT_FOR_EXIT, bwr.getTotalExitBandwidth(), bwr.getTotalBandwidth());
        double guardWeight = this.calculateWeight(rule == WeightRule.WEIGHT_FOR_GUARD, bwr.getTotalGuardBandwidth(), bwr.getTotalBandwidth());
        bwr.adjustWeights(exitWeight, guardWeight);
    }

    private double calculateWeight(boolean matchesRule, double totalByType, double total) {
        if (matchesRule || totalByType < 0.1) {
            return 1.0;
        }
        double result = 1.0 - total / (3.0 * totalByType);
        if (result <= 0.0) {
            return 0.0;
        }
        return result;
    }

    private long getRouterBandwidthBytes(Router r) {
        if (!r.hasBandwidth()) {
            return -1L;
        }
        return this.kbToBytes(r.getEstimatedBandwidth());
    }

    private long kbToBytes(long bw) {
        return bw > 9223372036854775L ? Long.MAX_VALUE : bw * 1000L;
    }

    public static enum WeightRule {
        WEIGHT_FOR_DIR,
        WEIGHT_FOR_EXIT,
        WEIGHT_FOR_MID,
        WEIGHT_FOR_GUARD,
        NO_WEIGHTING;

    }
}

