/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.data;

import android.util.Base64;
import java.math.BigDecimal;
import java.security.Key;
import java.security.KeyStore;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import milfont.com.tezosj_android.helper.Base58Check;
import milfont.com.tezosj_android.helper.Constants;
import milfont.com.tezosj_android.model.EncKeys;
import milfont.com.tezosj_android.model.SignedOperationGroup;
import milfont.com.tezosj_android.model.TezosWallet;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.encoders.Encoder;

public abstract class BaseGateway {
    abstract Object query(String var1, String var2) throws Exception;

    public JSONObject getHead() throws Exception {
        return (JSONObject)this.query("/chains/main/blocks/head", null);
    }

    public JSONObject getAccountManagerForBlock(String blockHash, String accountID) throws Exception {
        JSONObject result = (JSONObject)this.query("/chains/main/blocks/" + blockHash + "/context/contracts/" + accountID + "/manager_key", null);
        return result;
    }

    public JSONObject getBalance(String address) throws Exception {
        JSONObject result = (JSONObject)this.query("/chains/main/blocks/head/context/contracts/" + address + "/balance", null);
        return result;
    }

    private JSONObject sendOperation(JSONArray operations, EncKeys encKeys) throws Exception {
        SignedOperationGroup signedOpGroup;
        String operationGroupHash;
        JSONObject result = new JSONObject();
        JSONObject head = new JSONObject();
        String forgedOperationGroup = "";
        head = (JSONObject)this.query("/chains/main/blocks/head/header", null);
        JSONObject appliedOp = this.applyOperation(head, operations, operationGroupHash = this.computeOperationHash(signedOpGroup = this.signOperationGroup(forgedOperationGroup = this.forgeOperations(head, operations), encKeys)), forgedOperationGroup, signedOpGroup);
        JSONObject opResult = this.checkAppliedOperationResults(appliedOp);
        if (opResult.get("result").toString().length() == 0) {
            JSONObject injectedOperation = this.injectOperation(signedOpGroup);
            if (this.isJSONArray(injectedOperation.toString()).booleanValue()) {
                if (((JSONObject)((JSONArray)injectedOperation.get("result")).get(0)).has("error")) {
                    String err = (String)((JSONObject)((JSONArray)injectedOperation.get("result")).get(0)).get("error");
                    String reason = "There were errors: '" + err + "'";
                    result.put("result", (Object)reason);
                } else {
                    result.put("result", (Object)"");
                }
            } else if (this.isJSONObject(injectedOperation.toString()).booleanValue()) {
                if (injectedOperation.has("result")) {
                    if (this.isJSONArray(injectedOperation.get("result").toString()).booleanValue()) {
                        if (((JSONObject)((JSONArray)injectedOperation.get("result")).get(0)).has("error")) {
                            String err = (String)((JSONObject)((JSONArray)injectedOperation.get("result")).get(0)).get("error");
                            String reason = "There were errors: '" + err + "'";
                            result.put("result", (Object)reason);
                        } else {
                            result.put("result", (Object)"");
                        }
                    } else {
                        result.put("result", injectedOperation.get("result"));
                    }
                } else {
                    result.put("result", (Object)"There were errors.");
                }
            }
        } else {
            result.put("result", (Object)opResult.get("result").toString());
        }
        return result;
    }

    public JSONObject sendTransaction(String from, String to, BigDecimal amount, BigDecimal fee, String gasLimit, String storageLimit, EncKeys encKeys, JSONObject parameters) throws Exception {
        JSONObject result = new JSONObject();
        BigDecimal roundedAmount = amount.setScale(6, 4);
        BigDecimal roundedFee = fee.setScale(6, 4);
        JSONArray operations = new JSONArray();
        JSONObject revealOperation = new JSONObject();
        JSONObject transaction = new JSONObject();
        JSONObject head = new JSONObject();
        JSONObject account = new JSONObject();
        JSONObject param = new JSONObject();
        JSONArray argsArray = new JSONArray();
        Integer counter = 0;
        JSONObject balance = this.getBalance(from);
        if (balance.has("result")) {
            BigDecimal bdAmount = amount.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue()));
            BigDecimal total = new BigDecimal(balance.getString("result").replaceAll("\\n", "").replaceAll("\"", "").replaceAll("'", ""));
            if (total.compareTo(bdAmount) < 0) {
                JSONObject returned = new JSONObject();
                returned.put("result", (Object)"{ \"result\":\"error\", \"kind\":\"TezosJ_SDK_exception\", \"id\": \"Not enough funds\" }");
                return returned;
            }
        }
        if (gasLimit == null) {
            gasLimit = "15400";
        } else if (gasLimit.length() == 0 || gasLimit.equals("0")) {
            gasLimit = "15400";
        }
        if (storageLimit == null) {
            storageLimit = "300";
        } else if (storageLimit.length() == 0) {
            storageLimit = "300";
        }
        head = new JSONObject(this.query("/chains/main/blocks/head/header", null).toString());
        account = this.getAccountForBlock(head.get("hash").toString(), from);
        counter = Integer.parseInt(account.get("counter").toString());
        revealOperation = this.appendRevealOperation(head, encKeys, from, counter);
        if (revealOperation != null) {
            operations.put((Object)revealOperation);
            counter = counter + 1;
        }
        transaction.put("destination", (Object)to);
        transaction.put("amount", (Object)String.valueOf(roundedAmount.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("storage_limit", (Object)storageLimit);
        transaction.put("gas_limit", (Object)gasLimit);
        transaction.put("counter", (Object)String.valueOf(counter + 1));
        transaction.put("fee", (Object)String.valueOf(roundedFee.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("source", (Object)from);
        transaction.put("kind", (Object)"transaction");
        if (parameters != null && parameters.length() > 0) {
            transaction.put("parameters", (Object)parameters);
        }
        operations.put((Object)transaction);
        result = this.sendOperation(operations, encKeys);
        return result;
    }

    private SignedOperationGroup signOperationGroup(String forgedOperation, EncKeys encKeys) throws Exception {
        SignedOperationGroup signedOperationGroup = null;
        JSONObject signed = this.sign(Encoder.HEX.decode(forgedOperation), encKeys, "03");
        byte[] workBytes = ArrayUtils.addAll((byte[])Encoder.HEX.decode(forgedOperation), (byte[])Encoder.HEX.decode((String)signed.get("sig")));
        signedOperationGroup = new SignedOperationGroup(workBytes, (String)signed.get("edsig"), (String)signed.get("sbytes"));
        return signedOperationGroup;
    }

    private String forgeOperations(JSONObject blockHead, JSONArray operations) throws Exception {
        JSONObject result = new JSONObject();
        result.put("branch", blockHead.get("hash"));
        result.put("contents", (Object)operations);
        return this.nodeForgeOperations(result.toString());
    }

    private String nodeForgeOperations(String opGroup) throws Exception {
        JSONObject response = (JSONObject)this.query("/chains/main/blocks/head/helpers/forge/operations", opGroup);
        String forgedOperation = (String)response.get("result");
        return forgedOperation.replaceAll("\\n", "").replaceAll("\"", "").replaceAll("'", "");
    }

    private JSONObject getAccountForBlock(String blockHash, String accountID) throws Exception {
        JSONObject result = new JSONObject();
        result = (JSONObject)this.query("/chains/main/blocks/" + blockHash + "/context/contracts/" + accountID, null);
        return result;
    }

    private String computeOperationHash(SignedOperationGroup signedOpGroup) throws Exception {
        byte[] hash = new byte[32];
        NaCl.sodium();
        int r = Sodium.crypto_generichash(hash, hash.length, signedOpGroup.getTheBytes(), signedOpGroup.getTheBytes().length, signedOpGroup.getTheBytes(), 0);
        return Base58Check.encode(hash);
    }

    private JSONObject nodeApplyOperation(JSONArray payload) throws Exception {
        JSONObject response = (JSONObject)this.query("/chains/main/blocks/head/helpers/preapply/operations", payload.toString());
        return response;
    }

    private JSONObject applyOperation(JSONObject head, JSONArray operations, String operationGroupHash, String forgedOperationGroup, SignedOperationGroup signedOpGroup) throws Exception {
        JSONArray payload = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("protocol", head.get("protocol"));
        jsonObject.put("branch", head.get("hash"));
        jsonObject.put("contents", (Object)operations);
        jsonObject.put("signature", (Object)signedOpGroup.getSignature());
        payload.put((Object)jsonObject);
        return this.nodeApplyOperation(payload);
    }

    private JSONObject checkAppliedOperationResults(JSONObject appliedOp) throws Exception {
        JSONObject returned = new JSONObject();
        String error = "";
        String status = "";
        Boolean errors = false;
        String reason = "";
        String[] validAppliedKinds = new String[]{"activate_account", "reveal", "transaction", "origination", "delegation"};
        JSONObject firstAppliedOp = new JSONObject();
        firstAppliedOp = appliedOp;
        String firstApplyed = firstAppliedOp.toString().replaceAll("\\\\n", "").replaceAll("\\\\", "");
        JSONArray result = new JSONArray(new JSONObject(firstApplyed).get("result").toString());
        JSONObject first = (JSONObject)result.get(0);
        if (this.isJSONObject(first.toString()).booleanValue()) {
            if (first.has("kind") && first.has("id")) {
                errors = true;
                reason = "There were errors: kind '" + first.getString("kind") + "' id '" + first.getString("id") + "'";
            }
        } else if (this.isJSONArray(first.toString()).booleanValue()) {
            Integer elements = ((JSONArray)first.get("contents")).length();
            String element = "";
            Integer i = 0;
            while (i < elements) {
                JSONObject operation_result = (JSONObject)((JSONObject)((JSONObject)((JSONArray)first.get("contents")).get(i.intValue())).get("metadata")).get("operation_result");
                element = operation_result.getString("status");
                if (element.equals("failed")) {
                    errors = true;
                    if (!operation_result.has("errors")) break;
                    JSONObject err = (JSONObject)((JSONArray)operation_result.get("errors")).get(0);
                    reason = "There were errors: kind '" + err.getString("kind") + "' id '" + err.getString("id") + "'";
                    break;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if (errors.booleanValue()) {
            returned.put("result", (Object)reason);
        } else {
            returned.put("result", (Object)"");
        }
        return returned;
    }

    private JSONObject appendRevealOperation(JSONObject blockHead, EncKeys encKeys, String pkh, Integer counter) throws Exception {
        JSONObject revealOp = new JSONObject();
        byte[] bytePk = encKeys.getEncPublicKey();
        byte[] decPkBytes = BaseGateway.decryptBytes(bytePk, TezosWallet.getEncryptionKey(encKeys));
        StringBuilder builder2 = new StringBuilder();
        for (byte decPkByte : decPkBytes) {
            builder2.append((char)decPkByte);
        }
        String publicKey = builder2.toString();
        if (!this.isManagerKeyRevealedForAccount(blockHead, pkh)) {
            BigDecimal fee = new BigDecimal("0.001300");
            BigDecimal roundedFee = fee.setScale(6, 4);
            revealOp.put("kind", (Object)"reveal");
            revealOp.put("source", (Object)pkh);
            revealOp.put("fee", (Object)String.valueOf(roundedFee.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
            revealOp.put("counter", (Object)String.valueOf(counter + 1));
            revealOp.put("gas_limit", (Object)"10000");
            revealOp.put("storage_limit", (Object)"0");
            revealOp.put("public_key", (Object)publicKey);
        } else {
            revealOp = null;
        }
        return revealOp;
    }

    private boolean isManagerKeyRevealedForAccount(JSONObject blockHead, String pkh) throws Exception {
        Boolean result = false;
        String blockHeadHash = blockHead.getString("hash");
        String r = "";
        Boolean hasResult = this.getAccountManagerForBlock(blockHeadHash, pkh).has("result");
        if (hasResult.booleanValue()) {
            r = (String)this.getAccountManagerForBlock(blockHeadHash, pkh).get("result");
            r = r.replace("\"", "");
            r = r.replace("\n", "");
            result = (r = r.trim()).equals("null") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return result;
    }

    private JSONObject injectOperation(SignedOperationGroup signedOpGroup) throws Exception {
        String payload = signedOpGroup.getSbytes();
        return this.nodeInjectOperation("\"" + payload + "\"");
    }

    private JSONObject nodeInjectOperation(String payload) throws Exception {
        JSONObject result = (JSONObject)this.query("/injection/operation?chain=main", payload);
        return result;
    }

    public JSONObject sign(byte[] bytes, EncKeys keys, String watermark) throws Exception {
        byte[] byteSk = keys.getEncPrivateKey();
        byte[] decSkBytes = BaseGateway.decryptBytes(byteSk, this.getEncryptionKey(keys));
        StringBuilder builder = new StringBuilder();
        for (byte decSkByte : decSkBytes) {
            builder.append((char)decSkByte);
        }
        byte[] edskPrefix = new byte[]{43, -10, 78, 7};
        byte[] decodedSk = Base58Check.decode(builder.toString());
        byte[] privateKeyBytes = Arrays.copyOfRange(decodedSk, edskPrefix.length, decodedSk.length);
        byte[] workBytes = ArrayUtils.addAll((byte[])bytes, (byte[])new byte[0]);
        if (watermark != null) {
            byte[] wmBytes = Encoder.HEX.decode(watermark);
            workBytes = ArrayUtils.addAll((byte[])wmBytes, (byte[])workBytes);
        }
        byte[] hashedWorkBytes = new byte[32];
        NaCl.sodium();
        int rc = Sodium.crypto_generichash(hashedWorkBytes, hashedWorkBytes.length, workBytes, workBytes.length, workBytes, 0);
        int[] lengths = new int[]{64};
        byte[] sig = new byte[64];
        NaCl.sodium();
        int r = Sodium.crypto_sign_detached(sig, lengths, hashedWorkBytes, hashedWorkBytes.length, privateKeyBytes);
        byte[] edsigPrefix = new byte[]{9, -11, -51, -122, 18};
        byte[] edsigPrefixedSig = new byte[edsigPrefix.length + sig.length];
        edsigPrefixedSig = ArrayUtils.addAll((byte[])edsigPrefix, (byte[])sig);
        String edsig = Base58Check.encode(edsigPrefixedSig);
        String sbytes = Encoder.HEX.encode(bytes) + Encoder.HEX.encode(sig);
        JSONObject response = new JSONObject();
        response.put("bytes", (Object)Encoder.HEX.encode(bytes));
        response.put("sig", (Object)Encoder.HEX.encode(sig));
        response.put("edsig", (Object)edsig);
        response.put("sbytes", (Object)sbytes);
        return response;
    }

    Boolean isJSONObject(String myStr) {
        try {
            JSONObject testJSON = new JSONObject(myStr);
            testJSON = null;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    Boolean isJSONArray(String myStr) {
        try {
            JSONArray testJSONArray = new JSONArray(myStr);
            testJSONArray = null;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private byte[] getEncryptionKey(EncKeys keys) {
        try {
            String base64EncryptedPassword = keys.getEncP();
            String base64EncryptionIv = keys.getEncIv();
            byte[] encryptionIv = Base64.decode((String)base64EncryptionIv, (int)0);
            byte[] encryptionPassword = Base64.decode((String)base64EncryptedPassword, (int)0);
            KeyStore keystore = KeyStore.getInstance("AndroidKeyStore");
            keystore.load(null);
            SecretKey secretKey = (SecretKey)keystore.getKey("tzj", null);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptionIv));
            byte[] passwordBytes = cipher.doFinal(encryptionPassword);
            String password = new String(passwordBytes, "UTF-8");
            return passwordBytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static byte[] decryptBytes(byte[] encrypted, byte[] key) {
        try {
            SecretKeySpec keySpec = null;
            Cipher cipher = null;
            keySpec = new SecretKeySpec(key, "AES/ECB/PKCS7Padding");
            cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(2, keySpec);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject sendDelegationOperation(String delegator, String delegate, BigDecimal fee, String gasLimit, String storageLimit, EncKeys encKeys) throws Exception {
        JSONObject result = new JSONObject();
        BigDecimal roundedFee = fee.setScale(6, 4);
        JSONArray operations = new JSONArray();
        JSONObject revealOperation = new JSONObject();
        JSONObject transaction = new JSONObject();
        JSONObject head = new JSONObject();
        JSONObject account = new JSONObject();
        Integer counter = 0;
        if (gasLimit == null) {
            gasLimit = "10100";
        } else if (gasLimit.length() == 0 || gasLimit.equals("0")) {
            gasLimit = "10100";
        }
        if (storageLimit == null) {
            storageLimit = "0";
        } else if (storageLimit.length() == 0) {
            storageLimit = "0";
        }
        head = new JSONObject(this.query("/chains/main/blocks/head/header", null).toString());
        account = this.getAccountForBlock(head.get("hash").toString(), delegator);
        counter = Integer.parseInt(account.get("counter").toString());
        revealOperation = this.appendRevealOperation(head, encKeys, delegator, counter);
        if (revealOperation != null) {
            operations.put((Object)revealOperation);
            counter = counter + 1;
        }
        transaction.put("kind", (Object)"delegation");
        transaction.put("source", (Object)delegator);
        transaction.put("fee", (Object)String.valueOf(roundedFee.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("counter", (Object)String.valueOf(counter + 1));
        transaction.put("storage_limit", (Object)storageLimit);
        transaction.put("gas_limit", (Object)gasLimit);
        if (!delegate.equals("undefined")) {
            transaction.put("delegate", (Object)delegate);
        }
        operations.put((Object)transaction);
        result = this.sendOperation(operations, encKeys);
        return result;
    }

    public JSONObject sendOriginationOperation(String from, Boolean spendable, Boolean delegatable, BigDecimal fee, String gasLimit, String storageLimit, BigDecimal amount, String code, String storage, EncKeys encKeys) throws Exception {
        JSONObject result = new JSONObject();
        BigDecimal roundedAmount = amount.setScale(6, 4);
        BigDecimal roundedFee = fee.setScale(6, 4);
        JSONArray operations = new JSONArray();
        JSONObject revealOperation = new JSONObject();
        JSONObject transaction = new JSONObject();
        JSONObject head = new JSONObject();
        JSONObject account = new JSONObject();
        Integer counter = 0;
        if (gasLimit == null) {
            gasLimit = "10100";
        } else if (gasLimit.length() == 0 || gasLimit.equals("0")) {
            gasLimit = "10100";
        }
        if (storageLimit == null) {
            storageLimit = "277";
        } else if (storageLimit.length() == 0) {
            storageLimit = "277";
        }
        head = new JSONObject(this.query("/chains/main/blocks/head/header", null).toString());
        account = this.getAccountForBlock(head.get("hash").toString(), from);
        counter = Integer.parseInt(account.get("counter").toString());
        revealOperation = this.appendRevealOperation(head, encKeys, from, counter);
        if (revealOperation != null) {
            operations.put((Object)revealOperation);
            counter = counter + 1;
        }
        transaction.put("kind", (Object)"origination");
        transaction.put("source", (Object)from);
        transaction.put("fee", (Object)String.valueOf(roundedFee.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("counter", (Object)String.valueOf(counter + 1));
        transaction.put("gas_limit", (Object)gasLimit);
        transaction.put("storage_limit", (Object)storageLimit);
        transaction.put("manager_pubkey", (Object)from);
        transaction.put("balance", (Object)String.valueOf(roundedAmount.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("spendable", (Object)spendable);
        transaction.put("delegatable", (Object)delegatable);
        operations.put((Object)transaction);
        result = this.sendOperation(operations, encKeys);
        return result;
    }

    public JSONObject sendUndelegationOperation(String delegator, BigDecimal fee, EncKeys encKeys) throws Exception {
        return this.sendDelegationOperation(delegator, "undefined", fee, "", "", encKeys);
    }
}

