/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import com.facebook.crypto.mac.NativeMac;
import com.facebook.crypto.streams.TailInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NativeMacLayeredInputStream
extends InputStream {
    private final NativeMac mMac;
    private final TailInputStream mInputDelegate;
    private boolean mMacChecked = false;
    private static final String MAC_DOES_NOT_MATCH = "Mac does not match";

    public NativeMacLayeredInputStream(NativeMac mac, InputStream inputDelegate) {
        this.mMac = mac;
        this.mInputDelegate = new TailInputStream(inputDelegate, mac.getMacLength());
    }

    @Override
    public int available() throws IOException {
        return this.mInputDelegate.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.ensureMacValid();
        }
        finally {
            this.mInputDelegate.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer, 0, 1);
        while (read == 0) {
            read = this.read(buffer, 0, 1);
        }
        if (read == -1) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = this.mInputDelegate.read(buffer, offset, length);
        if (read == -1) {
            this.ensureMacValid();
            return -1;
        }
        if (read > 0) {
            this.mMac.update(buffer, offset, read);
        }
        return read;
    }

    private void ensureMacValid() throws IOException {
        if (this.mMacChecked) {
            return;
        }
        this.mMacChecked = true;
        try {
            byte[] mac = this.mMac.doFinal();
            if (!this.constantTimeEquals(this.mInputDelegate.getTail(), mac)) {
                throw new IOException(MAC_DOES_NOT_MATCH);
            }
        }
        finally {
            this.mMac.destroy();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        throw new UnsupportedOperationException();
    }

    private boolean constantTimeEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int compare = 0;
        for (int i = 0; i < a.length; ++i) {
            compare |= a[i] ^ b[i];
        }
        return compare == 0;
    }
}

