/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.keygen;

import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.security.SecureRandom;

public class PasswordBasedKeyDerivation {
    private static final int MINIMUM_SALT_LENGTH = 4;
    private static final int DEFAULT_SALT_LENGTH = 16;
    public static final int MINIMUM_ITERATIONS = 1;
    public static final int DEFAULT_ITERATIONS = 4096;
    public static final int MINIMUM_KEY_LENGTH = 8;
    public static final int DEFAULT_KEY_LENGTH = 16;
    private final NativeCryptoLibrary mNativeLibrary;
    private final SecureRandom mSecureRandom;
    private int mIterations;
    private String mPassword;
    private byte[] mSalt;
    private int mKeyLengthInBytes;
    private byte[] mGeneratedKey;

    public PasswordBasedKeyDerivation(SecureRandom secureRandom, NativeCryptoLibrary library) {
        this.mSecureRandom = secureRandom;
        this.mNativeLibrary = library;
        this.mIterations = 4096;
        this.mKeyLengthInBytes = 16;
    }

    public PasswordBasedKeyDerivation setIterations(int iterations) {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations cannot be less than 1");
        }
        this.mIterations = iterations;
        return this;
    }

    public PasswordBasedKeyDerivation setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        this.mPassword = password;
        return this;
    }

    public PasswordBasedKeyDerivation setSalt(byte[] salt) {
        if (salt != null && salt.length < 4) {
            throw new IllegalArgumentException("Salt cannot be shorter than 8 bytes");
        }
        this.mSalt = salt;
        return this;
    }

    public PasswordBasedKeyDerivation setKeyLengthInBytes(int keyLengthInBytes) {
        if (keyLengthInBytes < 8) {
            throw new IllegalArgumentException("Key length cannot be less than 8 bytes");
        }
        this.mKeyLengthInBytes = keyLengthInBytes;
        return this;
    }

    public byte[] generate() throws CryptoInitializationException {
        if (this.mPassword == null) {
            throw new IllegalStateException("Password was not set");
        }
        if (this.mSalt == null) {
            this.mSalt = new byte[16];
            this.mSecureRandom.nextBytes(this.mSalt);
        }
        this.mGeneratedKey = new byte[this.mKeyLengthInBytes];
        this.mNativeLibrary.ensureCryptoLoaded();
        int result = this.nativePbkdf2(this.mPassword, this.mSalt, this.mIterations, this.mGeneratedKey);
        if (result != 1) {
            throw new RuntimeException("Native PBKDF2 failed...");
        }
        return this.mGeneratedKey;
    }

    private native int nativePbkdf2(String var1, byte[] var2, int var3, byte[] var4);

    public int getIterations() {
        return this.mIterations;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public byte[] getSalt() {
        return this.mSalt;
    }

    public int getKeyLengthInBytes() {
        return this.mKeyLengthInBytes;
    }

    public byte[] getGeneratedKey() {
        return this.mGeneratedKey;
    }
}

