/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.certificate;

import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.directory.certificate.KeyCertificateImpl;
import com.subgraph.orchid.directory.certificate.KeyCertificateKeyword;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;

public class KeyCertificateParser
implements DocumentParser<KeyCertificate> {
    private static final int CURRENT_CERTIFICATE_VERSION = 3;
    private final DocumentFieldParser fieldParser;
    private KeyCertificateImpl currentCertificate;
    private DocumentParsingResultHandler<KeyCertificate> resultHandler;

    public KeyCertificateParser(DocumentFieldParser fieldParser) {
        this.fieldParser = fieldParser;
        this.fieldParser.setHandler(this.createParsingHandler());
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void parseKeywordLine() {
                KeyCertificateParser.this.processKeywordLine();
            }

            @Override
            public void endOfDocument() {
            }
        };
    }

    private void processKeywordLine() {
        KeyCertificateKeyword keyword = KeyCertificateKeyword.findKeyword(this.fieldParser.getCurrentKeyword());
        if (!keyword.equals((Object)KeyCertificateKeyword.UNKNOWN_KEYWORD)) {
            this.processKeyword(keyword);
        }
    }

    private void startNewCertificate() {
        this.fieldParser.resetRawDocument();
        this.fieldParser.startSignedEntity();
        this.currentCertificate = new KeyCertificateImpl();
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<KeyCertificate> resultHandler) {
        this.resultHandler = resultHandler;
        this.startNewCertificate();
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<KeyCertificate> parse() {
        BasicDocumentParsingResult<KeyCertificate> result = new BasicDocumentParsingResult<KeyCertificate>();
        this.parse((DocumentParsingResultHandler<KeyCertificate>)result);
        return result;
    }

    private void processKeyword(KeyCertificateKeyword keyword) {
        switch (keyword) {
            case DIR_KEY_CERTIFICATE_VERSION: {
                this.processCertificateVersion();
                break;
            }
            case DIR_ADDRESS: {
                this.processDirectoryAddress();
                break;
            }
            case FINGERPRINT: {
                this.currentCertificate.setAuthorityFingerprint(this.fieldParser.parseHexDigest());
                break;
            }
            case DIR_IDENTITY_KEY: {
                this.currentCertificate.setAuthorityIdentityKey(this.fieldParser.parsePublicKey());
                break;
            }
            case DIR_SIGNING_KEY: {
                this.currentCertificate.setAuthoritySigningKey(this.fieldParser.parsePublicKey());
                break;
            }
            case DIR_KEY_PUBLISHED: {
                this.currentCertificate.setKeyPublishedTime(this.fieldParser.parseTimestamp());
                break;
            }
            case DIR_KEY_EXPIRES: {
                this.currentCertificate.setKeyExpiryTime(this.fieldParser.parseTimestamp());
                break;
            }
            case DIR_KEY_CROSSCERT: {
                this.verifyCrossSignature(this.fieldParser.parseSignature());
                break;
            }
            case DIR_KEY_CERTIFICATION: {
                this.processCertificateSignature();
                break;
            }
        }
    }

    private void processCertificateVersion() {
        int version = this.fieldParser.parseInteger();
        if (version != 3) {
            throw new TorParsingException("Unexpected certificate version: " + version);
        }
    }

    private void processDirectoryAddress() {
        String addrport = this.fieldParser.parseString();
        String[] args = addrport.split(":");
        if (args.length != 2) {
            throw new TorParsingException("Address/Port string incorrectly formed: " + addrport);
        }
        this.currentCertificate.setDirectoryAddress(IPv4Address.createFromString(args[0]));
        this.currentCertificate.setDirectoryPort(this.fieldParser.parsePort(args[1]));
    }

    private void verifyCrossSignature(TorSignature crossSignature) {
        TorPublicKey identityKey = this.currentCertificate.getAuthorityIdentityKey();
        TorPublicKey signingKey = this.currentCertificate.getAuthoritySigningKey();
        if (!signingKey.verifySignature(crossSignature, identityKey.getFingerprint())) {
            throw new TorParsingException("Cross signature on certificate failed.");
        }
    }

    private boolean verifyCurrentCertificate(TorSignature signature) {
        if (!this.fieldParser.verifySignedEntity(this.currentCertificate.getAuthorityIdentityKey(), signature)) {
            this.resultHandler.documentInvalid(this.currentCertificate, "Signature failed");
            this.fieldParser.logWarn("Signature failed for certificate with fingerprint: " + this.currentCertificate.getAuthorityFingerprint());
            return false;
        }
        this.currentCertificate.setValidSignature();
        boolean isValid = this.currentCertificate.isValidDocument();
        if (!isValid) {
            this.resultHandler.documentInvalid(this.currentCertificate, "Certificate data is invalid");
            this.fieldParser.logWarn("Certificate data is invalid for certificate with fingerprint: " + this.currentCertificate.getAuthorityFingerprint());
        }
        return isValid;
    }

    private void processCertificateSignature() {
        this.fieldParser.endSignedEntity();
        if (this.verifyCurrentCertificate(this.fieldParser.parseSignature())) {
            this.currentCertificate.setRawDocumentData(this.fieldParser.getRawDocument());
            this.resultHandler.documentParsed(this.currentCertificate);
        }
        this.startNewCertificate();
    }
}

