/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data.exitpolicy;

import com.subgraph.orchid.data.exitpolicy.PortRange;
import java.util.ArrayList;
import java.util.List;

public class ExitPorts {
    private final List<PortRange> ranges = new ArrayList<PortRange>();
    private final boolean areAcceptPorts;

    public static ExitPorts createAcceptExitPorts(String ports) {
        ExitPorts exitPorts = new ExitPorts(true);
        exitPorts.parsePortRanges(ports);
        return exitPorts;
    }

    public static ExitPorts createRejectExitPorts(String ports) {
        ExitPorts exitPorts = new ExitPorts(false);
        exitPorts.parsePortRanges(ports);
        return exitPorts;
    }

    private ExitPorts(boolean acceptPorts) {
        this.areAcceptPorts = acceptPorts;
    }

    public boolean areAcceptPorts() {
        return this.areAcceptPorts;
    }

    public boolean acceptsPort(int port) {
        if (this.areAcceptPorts) {
            return this.contains(port);
        }
        return !this.contains(port);
    }

    public boolean contains(int port) {
        for (PortRange r : this.ranges) {
            if (!r.rangeContains(port)) continue;
            return true;
        }
        return false;
    }

    private void parsePortRanges(String portRanges) {
        String[] args;
        for (String arg : args = portRanges.split(",")) {
            this.ranges.add(PortRange.createFromString(arg));
        }
    }
}

