/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.RSAKeyEncoder;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.misc.Utils;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class TorPublicKey {
    private final String pemBuffer;
    private RSAPublicKey key;
    private byte[] rawKeyBytes = null;
    private HexDigest keyFingerprint = null;

    public static TorPublicKey createFromPEMBuffer(String buffer) {
        return new TorPublicKey(buffer);
    }

    private TorPublicKey(String pemBuffer) {
        this.pemBuffer = pemBuffer;
        this.key = null;
    }

    public TorPublicKey(RSAPublicKey key) {
        this.pemBuffer = null;
        this.key = key;
    }

    private synchronized RSAPublicKey getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.pemBuffer != null) {
            RSAKeyEncoder encoder = new RSAKeyEncoder();
            try {
                this.key = encoder.parsePEMPublicKey(this.pemBuffer);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Failed to parse PEM encoded key: " + e);
            }
        }
        return this.key;
    }

    public synchronized byte[] getRawBytes() {
        if (this.rawKeyBytes == null) {
            RSAKeyEncoder encoder = new RSAKeyEncoder();
            this.rawKeyBytes = encoder.getPKCS1Encoded(this.getKey());
        }
        return this.rawKeyBytes;
    }

    public synchronized HexDigest getFingerprint() {
        if (this.keyFingerprint == null) {
            this.keyFingerprint = HexDigest.createDigestForData(this.getRawBytes());
        }
        return this.keyFingerprint;
    }

    public boolean verifySignature(TorSignature signature, HexDigest digest) {
        return this.verifySignatureFromDigestBytes(signature, digest.getRawBytes());
    }

    public boolean verifySignature(TorSignature signature, TorMessageDigest digest) {
        return this.verifySignatureFromDigestBytes(signature, digest.getDigestBytes());
    }

    public boolean verifySignatureFromDigestBytes(TorSignature signature, byte[] digestBytes) {
        Cipher cipher = this.createCipherInstance();
        try {
            byte[] decrypted = cipher.doFinal(signature.getSignatureBytes());
            return Utils.constantTimeArrayEquals(decrypted, digestBytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new TorException(e);
        }
        catch (BadPaddingException e) {
            throw new TorException(e);
        }
    }

    private Cipher createCipherInstance() {
        try {
            Cipher cipher = this.getCipherInstance();
            cipher.init(2, this.getKey());
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new TorException(e);
        }
    }

    private Cipher getCipherInstance() {
        try {
            try {
                return Cipher.getInstance("RSA/ECB/PKCS1Padding", "SunJCE");
            }
            catch (NoSuchProviderException e) {
                return Cipher.getInstance("RSA/ECB/PKCS1Padding");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TorException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new TorException(e);
        }
    }

    public RSAPublicKey getRSAPublicKey() {
        return this.getKey();
    }

    public String toString() {
        return "Tor Public Key: " + this.getFingerprint();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TorPublicKey)) {
            return false;
        }
        TorPublicKey other = (TorPublicKey)o;
        return other.getFingerprint().equals(this.getFingerprint());
    }

    public int hashCode() {
        return this.getFingerprint().hashCode();
    }
}

