/*
 * Decompiled with CFR 0.152.
 */
package network.pocket.core.net;

import com.google.gson.Gson;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.pocket.core.errors.PocketError;
import network.pocket.core.model.Configuration;
import network.pocket.core.model.Node;
import network.pocket.core.model.Relay;
import network.pocket.core.model.Report;
import network.pocket.core.net.PocketAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnetwork/pocket/core/net/PocketAPI;", "", "()V", "Companion", "pocket-android-core_release"})
public final class PocketAPI {
    private static Gson gson;
    private static OkHttpClient client;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        gson = new Gson().newBuilder().create();
        client = new OkHttpClient().newBuilder().followRedirects(false).followSslRedirects(false).build();
    }

    public static final /* synthetic */ void access$setGson$cp(Gson gson) {
        PocketAPI.gson = gson;
    }

    public static final /* synthetic */ void access$setClient$cp(OkHttpClient okHttpClient) {
        client = okHttpClient;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2:\u0010\f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\t0\rJT\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182<\u0010\u0019\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u001a\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\t\u0018\u00010\rJL\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2<\u0010\u001e\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\t\u0018\u00010\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnetwork/pocket/core/net/PocketAPI$Companion;", "", "()V", "client", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "retrieveNodes", "", "configuration", "Lnetwork/pocket/core/model/Configuration;", "callback", "Lkotlin/Function2;", "Lnetwork/pocket/core/errors/PocketError;", "Lkotlin/ParameterName;", "name", "error", "Lorg/json/JSONArray;", "nodesJSON", "send", "relay", "Lnetwork/pocket/core/model/Relay;", "node", "Lnetwork/pocket/core/model/Node;", "relayCallback", "", "response", "report", "Lnetwork/pocket/core/model/Report;", "reportCallback", "Lorg/json/JSONObject;", "PocketApiCallback", "PocketApiJSONCallback", "pocket-android-core_release"})
    public static final class Companion {
        public final void send(@NotNull Relay relay, @NotNull Node node, @Nullable Function2<? super PocketError, ? super String, Unit> relayCallback) {
            Intrinsics.checkParameterIsNotNull((Object)relay, (String)"relay");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            String url = node.getIpPort() + "/v1/relay/";
            String json = gson.toJson((Object)relay);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).build();
            client.newCall(request).enqueue((Callback)new PocketApiCallback(node, relayCallback, relayCallback){
                final /* synthetic */ Node $node;
                final /* synthetic */ Function2 $relayCallback;

                public void onFailure(@NotNull Call call, @NotNull IOException error) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    super.onFailure(call, error);
                    String string = this.$node.getIp();
                    String string2 = error.getMessage();
                    if (string2 == null) {
                        string2 = "Request failed";
                    }
                    PocketAPI.Companion.send(new Report(string, string2), null);
                }
                {
                    this.$node = $captured_local_variable$0;
                    this.$relayCallback = $captured_local_variable$1;
                    super((Function2<? super PocketError, ? super String, Unit>)$super_call_param$2);
                }
            });
        }

        public final void send(@NotNull Report report, @Nullable Function2<? super PocketError, ? super JSONObject, Unit> reportCallback) {
            Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
            String url = "https://dispatch.pokt.network" + "/v1/report";
            String json = gson.toJson((Object)report);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).build();
            client.newCall(request).enqueue((Callback)new PocketApiJSONCallback(reportCallback));
        }

        public final void retrieveNodes(@NotNull Configuration configuration, @NotNull Function2<? super PocketError, ? super JSONArray, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            String url = "https://dispatch.pokt.network" + "/v1/dispatch";
            String json = gson.toJson((Object)configuration);
            Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).build();
            client.newCall(request).enqueue(new Callback(callback){
                final /* synthetic */ Function2 $callback;

                public void onFailure(@NotNull Call call, @NotNull IOException error) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    String string = error.getMessage();
                    if (string == null) {
                        string = "Request failed";
                    }
                    this.$callback.invoke((Object)new PocketError(string), null);
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    ResponseBody responseBody = response.body();
                    if (responseBody != null) {
                        ResponseBody responseBody2;
                        ResponseBody responseBody3 = responseBody2 = responseBody;
                        boolean bl = false;
                        Object jsonObj = new JSONTokener(responseBody3.string()).nextValue();
                        if (jsonObj instanceof JSONObject) {
                            this.$callback.invoke((Object)new PocketError("Invalid json format for " + jsonObj), null);
                        } else if (jsonObj instanceof JSONArray) {
                            this.$callback.invoke(null, jsonObj);
                        } else {
                            this.$callback.invoke((Object)new PocketError("Invalid JSON Array " + jsonObj), null);
                        }
                        return;
                    }
                    this.$callback.invoke((Object)new PocketError("Invalid Response"), null);
                }
                {
                    this.$callback = $captured_local_variable$0;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BE\b\u0016\u0012<\u0010\u0002\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0014H\u0016RN\u0010\u0002\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnetwork/pocket/core/net/PocketAPI$Companion$PocketApiJSONCallback;", "Lokhttp3/Callback;", "responseCallback", "Lkotlin/Function2;", "Lnetwork/pocket/core/errors/PocketError;", "Lkotlin/ParameterName;", "name", "error", "Lorg/json/JSONObject;", "response", "", "(Lkotlin/jvm/functions/Function2;)V", "getResponseCallback", "()Lkotlin/jvm/functions/Function2;", "setResponseCallback", "onFailure", "call", "Lokhttp3/Call;", "Ljava/io/IOException;", "onResponse", "Lokhttp3/Response;", "pocket-android-core_release"})
        public static class PocketApiJSONCallback
        implements Callback {
            @NotNull
            private Function2<? super PocketError, ? super JSONObject, Unit> responseCallback = responseCallback.1.INSTANCE;

            @NotNull
            public final Function2<PocketError, JSONObject, Unit> getResponseCallback() {
                return this.responseCallback;
            }

            public final void setResponseCallback(@NotNull Function2<? super PocketError, ? super JSONObject, Unit> function2) {
                Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
                this.responseCallback = function2;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException error) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                String string = error.getMessage();
                if (string == null) {
                    string = "Request failed";
                }
                this.responseCallback.invoke((Object)new PocketError(string), null);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    ResponseBody responseBody2;
                    ResponseBody responseBody3 = responseBody2 = responseBody;
                    boolean bl = false;
                    String string = responseBody3.string();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseBody.string()");
                    String responseBodyStr = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\n", (String)"", (boolean)false, (int)4, null), (String)"\\", (String)"", (boolean)false, (int)4, null), (String)"\"{", (String)"{", (boolean)false, (int)4, null), (String)"}\"", (String)"}", (boolean)false, (int)4, null);
                    try {
                        JSONObject json = new JSONObject(responseBodyStr);
                        this.responseCallback.invoke(null, (Object)json);
                    }
                    catch (Exception error) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to parse the response to a valid Json \n ").append(responseBodyStr).append(" \n ");
                        error.printStackTrace();
                        this.responseCallback.invoke((Object)new PocketError(stringBuilder.append(Unit.INSTANCE).toString()), null);
                    }
                    return;
                }
                this.responseCallback.invoke((Object)new PocketError("Invalid Response Body"), null);
            }

            public PocketApiJSONCallback(@Nullable Function2<? super PocketError, ? super JSONObject, Unit> responseCallback2) {
                Function2<? super PocketError, ? super JSONObject, Unit> function2 = responseCallback2;
                if (function2 == null) {
                    function2 = this.responseCallback;
                }
                this.responseCallback = function2;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BE\b\u0016\u0012<\u0010\u0002\u001a8\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0011H\u0016RB\u0010\u0002\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnetwork/pocket/core/net/PocketAPI$Companion$PocketApiCallback;", "Lokhttp3/Callback;", "responseCallback", "Lkotlin/Function2;", "Lnetwork/pocket/core/errors/PocketError;", "Lkotlin/ParameterName;", "name", "error", "", "response", "", "(Lkotlin/jvm/functions/Function2;)V", "onFailure", "call", "Lokhttp3/Call;", "Ljava/io/IOException;", "onResponse", "Lokhttp3/Response;", "pocket-android-core_release"})
        public static class PocketApiCallback
        implements Callback {
            private Function2<? super PocketError, ? super String, Unit> responseCallback = responseCallback.1.INSTANCE;

            public void onFailure(@NotNull Call call, @NotNull IOException error) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                String string = error.getMessage();
                if (string == null) {
                    string = "Request failed";
                }
                this.responseCallback.invoke((Object)new PocketError(string), null);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    ResponseBody responseBody2;
                    ResponseBody responseBody3 = responseBody2 = responseBody;
                    boolean bl = false;
                    String responseBodyStr = responseBody3.string();
                    try {
                        this.responseCallback.invoke(null, (Object)responseBodyStr);
                    }
                    catch (Exception error) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to parse the response to a valid Json \n ").append(responseBodyStr).append(" \n ");
                        error.printStackTrace();
                        this.responseCallback.invoke((Object)new PocketError(stringBuilder.append(Unit.INSTANCE).toString()), null);
                    }
                    return;
                }
                this.responseCallback.invoke((Object)new PocketError("Invalid Response Body"), null);
            }

            public PocketApiCallback(@Nullable Function2<? super PocketError, ? super String, Unit> responseCallback2) {
                Function2<? super PocketError, ? super String, Unit> function2 = responseCallback2;
                if (function2 == null) {
                    function2 = this.responseCallback;
                }
                this.responseCallback = function2;
            }
        }
    }
}

