/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.asymmetric;

import com.pvryan.easycrypt.asymmetric.ECVerifiedListener;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u0002H\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pvryan/easycrypt/asymmetric/performVerify;", "Lorg/jetbrains/anko/AnkoLogger;", "()V", "signature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "invoke", "", "T", "input", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "sigFile", "Ljava/io/File;", "evl", "Lcom/pvryan/easycrypt/asymmetric/ECVerifiedListener;", "invoke$easycrypt_release", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPublicKey;Ljava/io/File;Lcom/pvryan/easycrypt/asymmetric/ECVerifiedListener;)V", "easycrypt_release"})
public final class performVerify
implements AnkoLogger {
    private static final Signature signature;
    public static final performVerify INSTANCE;

    public final /* synthetic */ <T> void invoke$easycrypt_release(T input, @NotNull RSAPublicKey publicKey, @NotNull File sigFile, @NotNull ECVerifiedListener evl) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)sigFile, (String)"sigFile");
        Intrinsics.checkParameterIsNotNull((Object)evl, (String)"evl");
        signature.initVerify(publicKey);
        T t = input;
        if (t instanceof InputStream) {
            byte[] buffer = new byte[8192];
            long bytesCopied = 0L;
            try {
                long size = input instanceof FileInputStream ? ((FileInputStream)input).getChannel().size() : -1L;
                int read = ((InputStream)input).read(buffer);
                while (read > -1) {
                    signature.update(buffer, 0, read);
                    evl.onProgress(read, bytesCopied += (long)read, size);
                    read = ((InputStream)input).read(buffer);
                }
                try {
                    evl.onSuccess(signature.verify(DataTypeExtensionsKt.fromBase64(DataTypeExtensionsKt.asString(FilesKt.readBytes((File)sigFile)))));
                }
                catch (IllegalArgumentException e) {
                    evl.onFailure("Invalid base64 string.", e);
                }
                catch (SignatureException e) {
                    evl.onFailure("Cannot use provided signature to verify input data.", e);
                }
            }
            catch (IOException e) {
                evl.onFailure("Cannot write to file.", e);
            }
        } else {
            evl.onFailure("Input type not supported.", new InvalidParameterException());
        }
    }

    private performVerify() {
    }

    static {
        performVerify performVerify2;
        INSTANCE = performVerify2 = new performVerify();
        signature = Signature.getInstance("SHA512withRSA");
    }

    @NotNull
    public String getLoggerTag() {
        return AnkoLogger.DefaultImpls.getLoggerTag((AnkoLogger)this);
    }
}

