/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.asymmetric;

import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import kotlin.Metadata;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u0002H\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pvryan/easycrypt/asymmetric/performSign;", "Lorg/jetbrains/anko/AnkoLogger;", "()V", "signature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "invoke", "", "T", "input", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "invoke$easycrypt_release", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPrivateKey;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "easycrypt_release"})
public final class performSign
implements AnkoLogger {
    private static final Signature signature;
    public static final performSign INSTANCE;

    public final /* synthetic */ <T> void invoke$easycrypt_release(T input, @NotNull RSAPrivateKey privateKey, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        if (outputFile.exists()) {
            if (input instanceof InputStream) {
                ((InputStream)input).close();
            }
            erl.onFailure("Output file already exists.", (Exception)new FileAlreadyExistsException(outputFile, null, null, 6, null));
            return;
        }
        signature.initSign(privateKey);
        T t = input;
        if (t instanceof InputStream) {
            byte[] buffer = new byte[8192];
            long bytesCopied = 0L;
            try {
                long size = input instanceof FileInputStream ? ((FileInputStream)input).getChannel().size() : -1L;
                int read = ((InputStream)input).read(buffer);
                while (read > -1) {
                    signature.update(buffer, 0, read);
                    erl.onProgress(read, bytesCopied += (long)read, size);
                    read = ((InputStream)input).read(buffer);
                }
                byte[] byArray = signature.sign();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"signature.sign()");
                DataTypeExtensionsKt.handleSuccess(byArray, erl, outputFile, true);
            }
            catch (IOException e) {
                outputFile.delete();
                erl.onFailure("Cannot write to file.", e);
            }
            catch (SignatureException e) {
                outputFile.delete();
                erl.onFailure("This signature algorithm is unable to process the input data provided.", e);
            }
        } else {
            erl.onFailure("Input type not supported.", new InvalidParameterException());
        }
    }

    private performSign() {
    }

    static {
        performSign performSign2;
        INSTANCE = performSign2 = new performSign();
        signature = Signature.getInstance("SHA512withRSA");
    }

    @NotNull
    public String getLoggerTag() {
        return AnkoLogger.DefaultImpls.getLoggerTag((AnkoLogger)this);
    }
}

