/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.asymmetric;

import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECKeys;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.asymmetric.performEncrypt;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import com.pvryan.easycrypt.symmetric.ECSymmetric;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/pvryan/easycrypt/asymmetric/performEncrypt;", "", "()V", "invoke", "", "T", "input", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "cipher", "Ljavax/crypto/Cipher;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "invoke$easycrypt_release", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPublicKey;Ljavax/crypto/Cipher;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "easycrypt_release"})
public final class performEncrypt {
    public static final performEncrypt INSTANCE;

    public final /* synthetic */ <T> void invoke$easycrypt_release(T input, @NotNull RSAPublicKey publicKey, @NotNull Cipher cipher, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        if (outputFile.exists() && Intrinsics.areEqual((Object)outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ^ true) {
            T t = input;
            if (t instanceof InputStream) {
                ((InputStream)input).close();
            }
            erl.onFailure("Output file already exists.", (Exception)new FileAlreadyExistsException(outputFile, null, null, 6, null));
            return;
        }
        T t = input;
        if (t instanceof byte[]) {
            if (((byte[])input).length > DataTypeExtensionsKt.allowedInputSize(publicKey)) {
                String password = ECKeys.genSecureRandomPassword$default(new ECKeys(), 24, null, 2, null);
                ECSymmetric.encrypt$default(new ECSymmetric(null, 1, null), input, password, new ECResultListener(password, publicKey, cipher, erl, outputFile){
                    final /* synthetic */ String $password;
                    final /* synthetic */ RSAPublicKey $publicKey;
                    final /* synthetic */ Cipher $cipher;
                    final /* synthetic */ ECResultListener $erl;
                    final /* synthetic */ File $outputFile;

                    public <T> void onSuccess(T result) {
                        performEncrypt.INSTANCE.invoke$easycrypt_release(DataTypeExtensionsKt.asByteArray(this.$password), this.$publicKey, this.$cipher, new ECResultListener(this, result){
                            final /* synthetic */ invoke.1 this$0;
                            final /* synthetic */ Object $result;

                            public <T> void onSuccess(T cipherPass) {
                                try {
                                    T t = cipherPass;
                                    if (t == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    Object object = this.$result;
                                    if (object == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    DataTypeExtensionsKt.handleSuccess(ArraysKt.plus((byte[])DataTypeExtensionsKt.fromBase64((String)t), (byte[])DataTypeExtensionsKt.fromBase64((String)object)), this.this$0.$erl, this.this$0.$outputFile, true);
                                }
                                catch (IllegalArgumentException e) {
                                    this.this$0.$erl.onFailure("Invalid base64 string.", e);
                                }
                            }

                            public void onFailure(@NotNull String message, @NotNull Exception e) {
                                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                this.this$0.$erl.onFailure(message, e);
                            }
                            {
                                this.this$0 = $outer;
                                this.$result = $captured_local_variable$1;
                            }

                            public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                                ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                            }
                        }, this.$outputFile);
                    }

                    public void onFailure(@NotNull String message, @NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        this.$erl.onFailure(message, e);
                    }
                    {
                        this.$password = $captured_local_variable$0;
                        this.$publicKey = $captured_local_variable$1;
                        this.$cipher = $captured_local_variable$2;
                        this.$erl = $captured_local_variable$3;
                        this.$outputFile = $captured_local_variable$4;
                    }

                    public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                        ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                    }
                }, null, 8, null);
            } else {
                byte[] byArray = cipher.doFinal((byte[])input);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(input)");
                DataTypeExtensionsKt.handleSuccess(byArray, erl, outputFile, true);
            }
        } else if (t instanceof FileInputStream) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            String password = ECKeys.genSecureRandomPassword$default(new ECKeys(), 24, null, 2, null);
            new File(Constants.Companion.getDEF_EXT_TEMP_DIR_PATH()).mkdirs();
            File tempFile = new File(Constants.Companion.getDEF_EXT_TEMP_DIR_PATH(), "EncryptedFile.ecrypt");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            new ECSymmetric(null, 1, null).encrypt(input, password, new ECResultListener(erl, input, password, publicKey, cipher, outputFile){
                final /* synthetic */ ECResultListener $erl;
                final /* synthetic */ Object $input;
                final /* synthetic */ String $password;
                final /* synthetic */ RSAPublicKey $publicKey;
                final /* synthetic */ Cipher $cipher;
                final /* synthetic */ File $outputFile;

                public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                    this.$erl.onProgress(newBytes, bytesProcessed, ((FileInputStream)this.$input).getChannel().size());
                }

                public <T> void onSuccess(T result) {
                    performEncrypt.invoke$easycrypt_release$default(performEncrypt.INSTANCE, DataTypeExtensionsKt.asByteArray(this.$password), this.$publicKey, this.$cipher, new ECResultListener(this, result){
                        final /* synthetic */ invoke.2 this$0;
                        final /* synthetic */ Object $result;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        public <T> void onSuccess(T passCipher) {
                            block18: {
                                File file = this.this$0.$outputFile;
                                FileOutputStream fos = new FileOutputStream(file);
                                Object object = this.$result;
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                                }
                                File asOutputFile = (File)object;
                                Object object2 = asOutputFile;
                                object2 = new FileInputStream((File)object2);
                                Throwable throwable = null;
                                try {
                                    FileInputStream it = (FileInputStream)object2;
                                    try {
                                        T t = passCipher;
                                        if (t == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                        }
                                        byte[] passBytes = DataTypeExtensionsKt.fromBase64((String)t);
                                        fos.write(passBytes, 0, passBytes.length);
                                        byte[] buffer = new byte[8192];
                                        int read = it.read(buffer);
                                        while (read > -1) {
                                            fos.write(buffer, 0, read);
                                            read = it.read(buffer);
                                        }
                                    }
                                    catch (IllegalArgumentException e) {
                                        this.this$0.$erl.onFailure("Invalid base64 string.", e);
                                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                                        return;
                                    }
                                    catch (IOException e) {
                                        this.this$0.$erl.onFailure("Cannot write to file.", e);
                                        fos.flush();
                                        fos.close();
                                        asOutputFile.delete();
                                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                                        return;
                                        {
                                            catch (Throwable throwable2) {
                                                throw throwable2;
                                            }
                                        }
                                    }
                                    finally {
                                        fos.flush();
                                        fos.close();
                                        asOutputFile.delete();
                                    }
                                    this.this$0.$erl.onSuccess(this.this$0.$outputFile);
                                    Unit unit = Unit.INSTANCE;
                                    break block18;
                                    {
                                        catch (Throwable throwable3) {
                                            throwable = throwable3;
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throw throwable4;
                                        }
                                    }
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                                }
                            }
                        }

                        public void onFailure(@NotNull String message, @NotNull Exception e) {
                            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                            this.this$0.$erl.onFailure(message, e);
                        }
                        {
                            this.this$0 = $outer;
                            this.$result = $captured_local_variable$1;
                        }

                        public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                            ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                        }
                    }, null, 16, null);
                }

                public void onFailure(@NotNull String message, @NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$erl.onFailure(message, e);
                }
                {
                    this.$erl = $captured_local_variable$0;
                    this.$input = $captured_local_variable$1;
                    this.$password = $captured_local_variable$2;
                    this.$publicKey = $captured_local_variable$3;
                    this.$cipher = $captured_local_variable$4;
                    this.$outputFile = $captured_local_variable$5;
                }
            }, tempFile);
        }
    }

    public static /* bridge */ /* synthetic */ void invoke$easycrypt_release$default(performEncrypt performEncrypt2, Object object, RSAPublicKey rSAPublicKey, Cipher cipher, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 0x10) != 0) {
            file = new File(Constants.Companion.getDEF_ENCRYPTED_FILE_PATH());
        }
        performEncrypt2.invoke$easycrypt_release(object, rSAPublicKey, cipher, eCResultListener, file);
    }

    private performEncrypt() {
    }

    static {
        performEncrypt performEncrypt2;
        INSTANCE = performEncrypt2 = new performEncrypt();
    }
}

