/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.asymmetric;

import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.asymmetric.ECVerifiedListener;
import com.pvryan.easycrypt.asymmetric.performDecrypt;
import com.pvryan.easycrypt.asymmetric.performEncrypt;
import com.pvryan.easycrypt.asymmetric.performSign;
import com.pvryan.easycrypt.asymmetric.performVerify;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\b\b\u0001\u0010\b\u001a\u0002H\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ;\u0010\u0010\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\b\b\u0001\u0010\b\u001a\u0002H\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u0013J1\u0010\u0014\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0015\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pvryan/easycrypt/asymmetric/ECAsymmetric;", "", "()V", "cipher", "Ljavax/crypto/Cipher;", "decrypt", "", "T", "input", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPrivateKey;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "encrypt", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPublicKey;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "sign", "verify", "signature", "evl", "Lcom/pvryan/easycrypt/asymmetric/ECVerifiedListener;", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPublicKey;Ljava/io/File;Lcom/pvryan/easycrypt/asymmetric/ECVerifiedListener;)V", "KeySizes", "easycrypt_release"})
public final class ECAsymmetric {
    private final Cipher cipher;

    @JvmOverloads
    public final <T> void encrypt(@NotNull T input, @NotNull RSAPublicKey publicKey, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECAsymmetric>, Unit>(this, publicKey, erl, input, outputFile){
            final /* synthetic */ ECAsymmetric this$0;
            final /* synthetic */ RSAPublicKey $publicKey;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ Object $input;
            final /* synthetic */ File $outputFile;

            public final void invoke(@NotNull AnkoAsyncContext<ECAsymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                try {
                    RSAPublicKey rSAPublicKey = this.$publicKey;
                    if (rSAPublicKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.Key");
                    }
                    ECAsymmetric.access$getCipher$p(this.this$0).init(1, rSAPublicKey);
                }
                catch (InvalidKeyException e) {
                    this.$erl.onFailure("The key is not valid. Please provide a valid RSA key.", e);
                    return;
                }
                Object object = this.$input;
                if (object instanceof ByteArrayInputStream) {
                    this.this$0.encrypt(ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.$input), (int)0, (int)1, null), this.$publicKey, this.$erl, this.$outputFile);
                } else if (object instanceof String) {
                    this.this$0.encrypt(DataTypeExtensionsKt.asByteArray((String)this.$input), this.$publicKey, this.$erl, this.$outputFile);
                } else if (object instanceof CharSequence) {
                    this.this$0.encrypt(DataTypeExtensionsKt.asByteArray(this.$input.toString()), this.$publicKey, this.$erl, this.$outputFile);
                } else if (object instanceof File) {
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$erl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    File encryptedFile = Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ? new File(((File)this.$input).getAbsolutePath() + ".ecrypt") : this.$outputFile;
                    File file = (File)this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCAsymmetric.encrypt(fileInputStream, this.$publicKey, this.$erl, encryptedFile);
                } else {
                    performEncrypt.INSTANCE.invoke$easycrypt_release(this.$input, this.$publicKey, ECAsymmetric.access$getCipher$p(this.this$0), this.$erl, this.$outputFile);
                }
            }
            {
                this.this$0 = eCAsymmetric;
                this.$publicKey = rSAPublicKey;
                this.$erl = eCResultListener;
                this.$input = object;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void encrypt$default(ECAsymmetric eCAsymmetric, Object object, RSAPublicKey rSAPublicKey, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 8) != 0) {
            file = new File(Constants.Companion.getDEF_ENCRYPTED_FILE_PATH());
        }
        eCAsymmetric.encrypt(object, rSAPublicKey, eCResultListener, file);
    }

    @JvmOverloads
    public final <T> void encrypt(@NotNull T input, @NotNull RSAPublicKey publicKey, @NotNull ECResultListener erl) {
        ECAsymmetric.encrypt$default(this, input, publicKey, erl, null, 8, null);
    }

    @JvmOverloads
    public final <T> void decrypt(@NotNull T input, @NotNull RSAPrivateKey privateKey, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECAsymmetric>, Unit>(this, privateKey, erl, input, outputFile){
            final /* synthetic */ ECAsymmetric this$0;
            final /* synthetic */ RSAPrivateKey $privateKey;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ Object $input;
            final /* synthetic */ File $outputFile;

            public final void invoke(@NotNull AnkoAsyncContext<ECAsymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                try {
                    ECAsymmetric.access$getCipher$p(this.this$0).init(2, this.$privateKey);
                }
                catch (InvalidKeyException e) {
                    this.$erl.onFailure("The key is not valid. Please provide a valid RSA key.", e);
                    return;
                }
                Object object = this.$input;
                if (object instanceof ByteArrayInputStream) {
                    this.this$0.decrypt(ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.$input), (int)0, (int)1, null), this.$privateKey, this.$erl, this.$outputFile);
                } else if (object instanceof String) {
                    try {
                        this.this$0.decrypt(DataTypeExtensionsKt.fromBase64((String)this.$input), this.$privateKey, this.$erl, this.$outputFile);
                    }
                    catch (IllegalArgumentException e) {
                        this.$erl.onFailure("Invalid base64 string.", e);
                    }
                } else if (object instanceof CharSequence) {
                    try {
                        this.this$0.decrypt(DataTypeExtensionsKt.fromBase64(this.$input.toString()), this.$privateKey, this.$erl, this.$outputFile);
                    }
                    catch (IllegalArgumentException e) {
                        this.$erl.onFailure("Invalid base64 string.", e);
                    }
                } else if (object instanceof File) {
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$erl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    File decryptedFile = Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ? new File(((File)this.$input).getAbsolutePath() + ".ecrypt") : this.$outputFile;
                    File file = (File)this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCAsymmetric.decrypt(fileInputStream, this.$privateKey, this.$erl, decryptedFile);
                } else {
                    performDecrypt.INSTANCE.invoke$easycrypt_release(this.$input, this.$privateKey, ECAsymmetric.access$getCipher$p(this.this$0), this.$erl, this.$outputFile);
                }
            }
            {
                this.this$0 = eCAsymmetric;
                this.$privateKey = rSAPrivateKey;
                this.$erl = eCResultListener;
                this.$input = object;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void decrypt$default(ECAsymmetric eCAsymmetric, Object object, RSAPrivateKey rSAPrivateKey, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 8) != 0) {
            file = new File(Constants.Companion.getDEF_DECRYPTED_FILE_PATH());
        }
        eCAsymmetric.decrypt(object, rSAPrivateKey, eCResultListener, file);
    }

    @JvmOverloads
    public final <T> void decrypt(@NotNull T input, @NotNull RSAPrivateKey privateKey, @NotNull ECResultListener erl) {
        ECAsymmetric.decrypt$default(this, input, privateKey, erl, null, 8, null);
    }

    public final <T> void sign(T input, @NotNull RSAPrivateKey privateKey, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECAsymmetric>, Unit>(this, input, privateKey, erl, outputFile){
            final /* synthetic */ ECAsymmetric this$0;
            final /* synthetic */ Object $input;
            final /* synthetic */ RSAPrivateKey $privateKey;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ File $outputFile;

            public final void invoke(@NotNull AnkoAsyncContext<ECAsymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Object object = this.$input;
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.sign(byteArrayInputStream, this.$privateKey, this.$erl, this.$outputFile);
                } else if (object instanceof String) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray((String)this.$input);
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.sign(byteArrayInputStream, this.$privateKey, this.$erl, this.$outputFile);
                } else if (object instanceof CharSequence) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray(this.$input.toString());
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.sign(byteArrayInputStream, this.$privateKey, this.$erl, this.$outputFile);
                } else if (object instanceof File) {
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$erl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    File file = (File)this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCAsymmetric.sign(fileInputStream, this.$privateKey, this.$erl, this.$outputFile);
                } else {
                    performSign.INSTANCE.invoke$easycrypt_release(this.$input, this.$privateKey, this.$erl, this.$outputFile);
                }
            }
            {
                this.this$0 = eCAsymmetric;
                this.$input = object;
                this.$privateKey = rSAPrivateKey;
                this.$erl = eCResultListener;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    public final <T> void verify(T input, @NotNull RSAPublicKey publicKey, @NotNull File signature, @NotNull ECVerifiedListener evl) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)evl, (String)"evl");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECAsymmetric>, Unit>(this, input, publicKey, signature, evl){
            final /* synthetic */ ECAsymmetric this$0;
            final /* synthetic */ Object $input;
            final /* synthetic */ RSAPublicKey $publicKey;
            final /* synthetic */ File $signature;
            final /* synthetic */ ECVerifiedListener $evl;

            public final void invoke(@NotNull AnkoAsyncContext<ECAsymmetric> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Object object = this.$input;
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.verify(byteArrayInputStream, this.$publicKey, this.$signature, this.$evl);
                } else if (object instanceof String) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray((String)this.$input);
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.verify(byteArrayInputStream, this.$publicKey, this.$signature, this.$evl);
                } else if (object instanceof CharSequence) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray(this.$input.toString());
                    ECAsymmetric eCAsymmetric = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCAsymmetric.verify(byteArrayInputStream, this.$publicKey, this.$signature, this.$evl);
                } else if (object instanceof File) {
                    if (!((File)this.$input).exists() || ((File)this.$input).isDirectory()) {
                        this.$evl.onFailure("File does not exist.", (Exception)new NoSuchFileException((File)this.$input, null, null, 6, null));
                        return;
                    }
                    File file = (File)this.$input;
                    ECAsymmetric eCAsymmetric = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCAsymmetric.verify(fileInputStream, this.$publicKey, this.$signature, this.$evl);
                } else {
                    performVerify.INSTANCE.invoke$easycrypt_release(this.$input, this.$publicKey, this.$signature, this.$evl);
                }
            }
            {
                this.this$0 = eCAsymmetric;
                this.$input = object;
                this.$publicKey = rSAPublicKey;
                this.$signature = file;
                this.$evl = eCVerifiedListener;
                super(1);
            }
        }), (int)1, null);
    }

    public ECAsymmetric() {
        Cipher cipher = Cipher.getInstance("RSA/NONE/OAEPwithSHA-256andMGF1Padding");
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"Cipher.getInstance(Const\u2026SYMMETRIC_TRANSFORMATION)");
        this.cipher = cipher;
    }

    @NotNull
    public static final /* synthetic */ Cipher access$getCipher$p(ECAsymmetric $this) {
        return $this.cipher;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/pvryan/easycrypt/asymmetric/ECAsymmetric$KeySizes;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "S_2048", "S_4096", "easycrypt_release"})
    public static final class KeySizes
    extends Enum<KeySizes> {
        public static final /* enum */ KeySizes S_2048;
        public static final /* enum */ KeySizes S_4096;
        private static final /* synthetic */ KeySizes[] $VALUES;
        private final int value;

        static {
            KeySizes[] keySizesArray = new KeySizes[2];
            KeySizes[] keySizesArray2 = keySizesArray;
            keySizesArray[0] = S_2048 = new KeySizes(2048);
            keySizesArray[1] = S_4096 = new KeySizes(4096);
            $VALUES = keySizesArray;
        }

        public final int getValue() {
            return this.value;
        }

        protected KeySizes(int value) {
            this.value = value;
        }

        public static KeySizes[] values() {
            return (KeySizes[])$VALUES.clone();
        }

        public static KeySizes valueOf(String string) {
            return Enum.valueOf(KeySizes.class, string);
        }
    }
}

