/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt;

import com.google.gson.JsonArray;
import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.asymmetric.ECAsymmetric;
import com.pvryan.easycrypt.asymmetric.ECRSAKeyPairListener;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import com.pvryan.easycrypt.randomorg.RandomOrg;
import com.pvryan.easycrypt.randomorg.RandomOrgResponse;
import com.pvryan.easycrypt.symmetric.ECPasswordListener;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0003\u0010\u0016\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/pvryan/easycrypt/ECKeys;", "", "()V", "genRSAKeyPair", "", "kpl", "Lcom/pvryan/easycrypt/asymmetric/ECRSAKeyPairListener;", "keySize", "Lcom/pvryan/easycrypt/asymmetric/ECAsymmetric$KeySizes;", "genRSAPrivateKeyFromBase64", "Ljava/security/interfaces/RSAPrivateKey;", "keyBase64String", "", "genRSAPublicKeyFromBase64", "Ljava/security/interfaces/RSAPublicKey;", "genRandomOrgPassword", "length", "", "randomOrgApiKey", "resultListener", "Lcom/pvryan/easycrypt/symmetric/ECPasswordListener;", "genSecureRandomPassword", "symbols", "", "easycrypt_release"})
public final class ECKeys {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String genSecureRandomPassword(@NotNull int length, @NotNull char[] symbols) throws InvalidParameterException {
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        if (length < 1 || length > 4096) {
            throw (Throwable)new InvalidParameterException("Invalid length. Valid range is 1 to 4096.");
        }
        char[] cArray = symbols;
        if (cArray.length == 0) {
            throw (Throwable)new InvalidParameterException("Array of symbols cannot be empty.");
        }
        char[] password = new char[length];
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            password[i] = symbols[Constants.Companion.getRandom().nextInt(symbols.length - 1)];
            ++i;
        }
        return ArraysKt.joinToString$default((char[])password, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ String genSecureRandomPassword$default(ECKeys eCKeys, int n, char[] cArray, int n2, Object object) throws InvalidParameterException {
        if ((n2 & 2) != 0) {
            String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            char[] cArray2 = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            cArray = cArray2;
        }
        return eCKeys.genSecureRandomPassword(n, cArray);
    }

    @JvmOverloads
    @NotNull
    public final String genSecureRandomPassword(@NotNull int length) throws InvalidParameterException {
        return ECKeys.genSecureRandomPassword$default(this, length, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void genRandomOrgPassword(@NotNull int length, @NotNull String randomOrgApiKey, @NotNull ECPasswordListener resultListener) {
        void oddLength;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)randomOrgApiKey, (String)"randomOrgApiKey");
        Intrinsics.checkParameterIsNotNull((Object)resultListener, (String)"resultListener");
        if (length < 1 || length > 4096) {
            resultListener.onFailure("Invalid length.", new InvalidParameterException("Valid range is 1 to 4096."));
            return;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (length % 2 != 0) {
            oddLength.element = true;
            n = length + 1;
        } else {
            n = length;
        }
        int passLength = n;
        RandomOrg.Companion.request$easycrypt_release(randomOrgApiKey, passLength, (Callback<RandomOrgResponse>)((Callback)new Callback<RandomOrgResponse>(resultListener, (Ref.BooleanRef)oddLength){
            final /* synthetic */ ECPasswordListener $resultListener;
            final /* synthetic */ Ref.BooleanRef $oddLength;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull Call<RandomOrgResponse> call, @NotNull Response<RandomOrgResponse> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                if (200 == response.code()) {
                    RandomOrgResponse body = (RandomOrgResponse)response.body();
                    if (body != null) {
                        if (body.getError() != null) {
                            this.$resultListener.onFailure("Error response from random.org", new InvalidParameterException(body.getError().getMessage()));
                            return;
                        }
                        JsonArray randomKeyArray = body.getResult().getRandom().getData();
                        StringBuilder randomKeyHex = new StringBuilder();
                        int n = 0;
                        int n2 = randomKeyArray.size() - 1;
                        if (n <= n2) {
                            while (true) {
                                void i;
                                String string = randomKeyArray.get((int)i).toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"randomKeyArray[i].toString()");
                                randomKeyHex.append(StringsKt.replace((String)string, (String)"\"", (String)"", (boolean)true));
                                if (i == n2) break;
                                ++i;
                            }
                        }
                        if (this.$oddLength.element) {
                            String string = randomKeyHex.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"randomKeyHex.toString()");
                            this.$resultListener.onGenerated(StringsKt.dropLast((String)string, (int)1));
                        } else {
                            String string = randomKeyHex.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"randomKeyHex.toString()");
                            this.$resultListener.onGenerated(string);
                        }
                    } else {
                        Object object = response.errorBody();
                        if (object == null || (object = object.string()) == null) {
                            object = "Null response from Random.org. Please try again.";
                        }
                        this.$resultListener.onFailure("Random.org error.", new Exception((String)object));
                    }
                } else {
                    String string = "Response code " + response.code();
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) {
                        object = "Some error occurred at Random.org. Please try again.";
                    }
                    this.$resultListener.onFailure(string, new Exception((String)object));
                }
            }

            public void onFailure(@NotNull Call<RandomOrgResponse> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                String string = t.getLocalizedMessage();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"t.localizedMessage");
                this.$resultListener.onFailure(string, new Exception(t));
            }
            {
                this.$resultListener = $captured_local_variable$0;
                this.$oddLength = $captured_local_variable$1;
            }
        }));
    }

    @JvmOverloads
    public final void genRSAKeyPair(@NotNull ECRSAKeyPairListener kpl, @NotNull ECAsymmetric.KeySizes keySize) {
        Intrinsics.checkParameterIsNotNull((Object)kpl, (String)"kpl");
        Intrinsics.checkParameterIsNotNull((Object)((Object)keySize), (String)"keySize");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECKeys>, Unit>(keySize, kpl){
            final /* synthetic */ ECAsymmetric.KeySizes $keySize;
            final /* synthetic */ ECRSAKeyPairListener $kpl;

            public final void invoke(@NotNull AnkoAsyncContext<ECKeys> $receiver) {
                KeyPair keyPair;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
                generator.initialize(this.$keySize.getValue(), Constants.Companion.getRandom());
                KeyPair keyPair2 = keyPair = generator.generateKeyPair();
                Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"keyPair");
                this.$kpl.onGenerated(keyPair2);
            }
            {
                this.$keySize = keySizes;
                this.$kpl = eCRSAKeyPairListener;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void genRSAKeyPair$default(ECKeys eCKeys, ECRSAKeyPairListener eCRSAKeyPairListener, ECAsymmetric.KeySizes keySizes, int n, Object object) {
        if ((n & 2) != 0) {
            keySizes = ECAsymmetric.KeySizes.S_4096;
        }
        eCKeys.genRSAKeyPair(eCRSAKeyPairListener, keySizes);
    }

    @JvmOverloads
    public final void genRSAKeyPair(@NotNull ECRSAKeyPairListener kpl) {
        ECKeys.genRSAKeyPair$default(this, kpl, null, 2, null);
    }

    @NotNull
    public final RSAPublicKey genRSAPublicKeyFromBase64(@NotNull String keyBase64String) throws IllegalArgumentException, InvalidKeySpecException {
        Intrinsics.checkParameterIsNotNull((Object)keyBase64String, (String)"keyBase64String");
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(DataTypeExtensionsKt.fromBase64(keyBase64String)));
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        return (RSAPublicKey)publicKey;
    }

    @NotNull
    public final RSAPrivateKey genRSAPrivateKeyFromBase64(@NotNull String keyBase64String) throws IllegalArgumentException, InvalidKeySpecException {
        Intrinsics.checkParameterIsNotNull((Object)keyBase64String, (String)"keyBase64String");
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(DataTypeExtensionsKt.fromBase64(keyBase64String)));
        if (privateKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        }
        return (RSAPrivateKey)privateKey;
    }
}

