/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TailInputStream
extends FilterInputStream {
    private final byte[] mTail;
    private final int mTailTength;
    private int mCount;
    private boolean mEOF;

    protected TailInputStream(InputStream in, int tailLength) {
        super(in);
        this.mTail = new byte[tailLength];
        this.mTailTength = tailLength;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer, 0, 1);
        while (read == 0) {
            read = this.read(buffer, 0, 1);
        }
        if (read == -1) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.mEOF) {
            return -1;
        }
        if (count == 0) {
            return 0;
        }
        int read = 0;
        while (read == 0) {
            read = this.readTail(buffer, offset, count);
        }
        return read;
    }

    private int readTail(byte[] buffer, int offset, int count) throws IOException {
        if (count >= this.mCount) {
            int remain = count - this.mCount;
            int readBytes = this.in.read(buffer, offset + this.mCount, remain);
            if (readBytes == -1) {
                this.mEOF = true;
                return -1;
            }
            if (this.mCount > 0) {
                System.arraycopy(this.mTail, 0, buffer, offset, this.mCount);
            }
            int dataInBuffer = this.mCount + readBytes;
            int tailBytes = this.in.read(this.mTail, 0, this.mTailTength);
            if (tailBytes == -1) {
                this.mEOF = true;
                tailBytes = 0;
            }
            return this.extractTail(buffer, dataInBuffer, tailBytes, offset);
        }
        int newLength = this.mCount - count;
        System.arraycopy(this.mTail, 0, buffer, offset, count);
        System.arraycopy(this.mTail, count, this.mTail, 0, newLength);
        int tailBytes = this.in.read(this.mTail, newLength, this.mTailTength - newLength);
        if (tailBytes == -1) {
            System.arraycopy(this.mTail, 0, this.mTail, count, newLength);
            System.arraycopy(buffer, offset, this.mTail, 0, count);
            this.mEOF = true;
            return -1;
        }
        return this.extractTail(buffer, count, tailBytes + newLength, offset);
    }

    private int extractTail(byte[] readBuffer, int bytesInBuffer, int tailBytes, int bufferOffset) {
        int toFill = this.mTailTength - tailBytes;
        int tailOffsetInBuffer = Math.max(0, bytesInBuffer - toFill) + bufferOffset;
        int bytesToCopy = Math.min(toFill, bytesInBuffer);
        if (bytesToCopy > 0) {
            if (tailBytes > 0) {
                System.arraycopy(this.mTail, 0, this.mTail, bytesToCopy, tailBytes);
            }
            System.arraycopy(readBuffer, tailOffsetInBuffer, this.mTail, 0, bytesToCopy);
        }
        this.mCount = bytesToCopy + tailBytes;
        return tailOffsetInBuffer - bufferOffset;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public byte[] getTail() throws IOException {
        if (this.mCount != this.mTailTength) {
            throw new IOException("Not enough tail data");
        }
        return this.mTail;
    }
}

