/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import com.facebook.crypto.cipher.NativeGCMCipher;
import java.io.IOException;
import java.io.OutputStream;

public class NativeGCMCipherOutputStream
extends OutputStream {
    private static final int DEFAULT_ENCRYPT_BUFFER_SIZE = 256;
    private final OutputStream mCipherDelegate;
    private final NativeGCMCipher mCipher;
    private final int mUpdateBufferChunkSize;
    private final byte[] mUpdateBuffer;
    private final byte[] mTag;
    private boolean mTagAppended = false;

    public NativeGCMCipherOutputStream(OutputStream cipherDelegate, NativeGCMCipher cipher, byte[] encryptBuffer, int tagLength) {
        this.mCipherDelegate = cipherDelegate;
        this.mCipher = cipher;
        this.mTag = new byte[tagLength];
        int cipherBlockSize = this.mCipher.getCipherBlockSize();
        if (encryptBuffer == null) {
            encryptBuffer = new byte[256 + cipherBlockSize];
        } else {
            int minSize = cipherBlockSize + 1;
            if (encryptBuffer.length < minSize) {
                throw new IllegalArgumentException("encryptBuffer cannot be smaller than " + minSize + "B");
            }
        }
        this.mUpdateBufferChunkSize = encryptBuffer.length - cipherBlockSize;
        this.mUpdateBuffer = encryptBuffer;
    }

    @Override
    public void close() throws IOException {
        try {
            this.appendTag();
        }
        finally {
            this.mCipherDelegate.close();
        }
    }

    private void appendTag() throws IOException {
        if (this.mTagAppended) {
            return;
        }
        this.mTagAppended = true;
        try {
            this.mCipher.encryptFinal(this.mTag, this.mTag.length);
            this.mCipherDelegate.write(this.mTag);
        }
        finally {
            this.mCipher.destroy();
        }
    }

    @Override
    public void flush() throws IOException {
        this.mCipherDelegate.flush();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (buffer.length < offset + count) {
            throw new ArrayIndexOutOfBoundsException(offset + count);
        }
        int times = count / this.mUpdateBufferChunkSize;
        int remainder = count % this.mUpdateBufferChunkSize;
        for (int i = 0; i < times; ++i) {
            int written = this.mCipher.update(buffer, offset, this.mUpdateBufferChunkSize, this.mUpdateBuffer, 0);
            this.mCipherDelegate.write(this.mUpdateBuffer, 0, written);
            offset += this.mUpdateBufferChunkSize;
        }
        if (remainder > 0) {
            int written = this.mCipher.update(buffer, offset, remainder, this.mUpdateBuffer, 0);
            this.mCipherDelegate.write(this.mUpdateBuffer, 0, written);
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] data = new byte[]{(byte)oneByte};
        this.write(data, 0, 1);
    }
}

