/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import com.facebook.crypto.cipher.NativeGCMCipher;
import com.facebook.crypto.streams.TailInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NativeGCMCipherInputStream
extends InputStream {
    private static final int SKIP_BUFFER_SIZE = 256;
    private final TailInputStream mCipherDelegate;
    private final NativeGCMCipher mCipher;
    private byte[] mSkipBuffer;
    private boolean mTagChecked = false;

    public NativeGCMCipherInputStream(InputStream cipherDelegate, NativeGCMCipher cipher, int tagLength) {
        this.mCipherDelegate = new TailInputStream(cipherDelegate, tagLength);
        this.mCipher = cipher;
    }

    @Override
    public int available() throws IOException {
        return this.mCipherDelegate.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.ensureTagValid();
        }
        finally {
            this.mCipherDelegate.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (buffer.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException(offset + length);
        }
        int read = this.mCipherDelegate.read(buffer, offset, length);
        if (read == -1) {
            this.ensureTagValid();
            return -1;
        }
        read = this.mCipher.update(buffer, offset, read, buffer, offset);
        return read;
    }

    private void ensureTagValid() throws IOException {
        if (this.mTagChecked) {
            return;
        }
        this.mTagChecked = true;
        try {
            byte[] tail = this.mCipherDelegate.getTail();
            this.mCipher.decryptFinal(tail, tail.length);
        }
        finally {
            this.mCipher.destroy();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        int chunk;
        int read;
        if (this.mSkipBuffer == null) {
            this.mSkipBuffer = new byte[256];
        }
        long skipped = 0L;
        while (byteCount > 0L && (read = this.read(this.mSkipBuffer, 0, chunk = (int)Math.min(byteCount, 256L))) >= 0) {
            skipped += (long)read;
            byteCount -= (long)read;
        }
        return skipped == 0L ? -1L : skipped;
    }
}

