/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.cipher;

import com.facebook.crypto.cipher.NativeGCMCipherException;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.proguard.annotations.DoNotStrip;
import com.facebook.crypto.util.Assertions;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.util.Locale;

@DoNotStrip
public class NativeGCMCipher {
    public static final String FAILURE = "Failure";
    private static final String CIPHER_ALREADY_INIT = "Cipher has already been initialized";
    private static final String CIPHER_NOT_INIT = "Cipher has not been initialized";
    private static final String CIPHER_NOT_FINALIZED = "Cipher has not been finalized";
    private STATE mCurrentState = STATE.UNINITIALIZED;
    private final NativeCryptoLibrary mNativeCryptoLibrary;
    @DoNotStrip
    private long mCtxPtr;

    public NativeGCMCipher(NativeCryptoLibrary nativeCryptoLibrary) {
        this.mNativeCryptoLibrary = nativeCryptoLibrary;
    }

    public void encryptInit(byte[] key, byte[] iv) throws NativeGCMCipherException, CryptoInitializationException {
        Assertions.checkState(this.mCurrentState == STATE.UNINITIALIZED, CIPHER_ALREADY_INIT);
        this.mNativeCryptoLibrary.ensureCryptoLoaded();
        if (this.nativeEncryptInit(key, iv) == NativeGCMCipher.nativeFailure()) {
            throw new NativeGCMCipherException("encryptInit");
        }
        this.mCurrentState = STATE.ENCRYPT_INITIALIZED;
    }

    public void decryptInit(byte[] key, byte[] iv) throws NativeGCMCipherException, CryptoInitializationException {
        Assertions.checkState(this.mCurrentState == STATE.UNINITIALIZED, CIPHER_ALREADY_INIT);
        this.mNativeCryptoLibrary.ensureCryptoLoaded();
        if (this.nativeDecryptInit(key, iv) == NativeGCMCipher.nativeFailure()) {
            throw new NativeGCMCipherException("decryptInit");
        }
        this.mCurrentState = STATE.DECRYPT_INITIALIZED;
    }

    public int update(byte[] data, int offset, int dataLen, byte[] output, int outputOffset) throws NativeGCMCipherException {
        this.ensureInInitalizedState();
        int bytesRead = this.nativeUpdate(data, offset, dataLen, output, outputOffset);
        if (bytesRead < 0) {
            throw new NativeGCMCipherException(this.formatStrLocaleSafe("update: Offset = %d; DataLen = %d; Result = %d", offset, dataLen, bytesRead));
        }
        return bytesRead;
    }

    public void updateAad(byte[] data, int dataLength) throws NativeGCMCipherException {
        this.ensureInInitalizedState();
        if (this.nativeUpdateAad(data, dataLength) < 0) {
            throw new NativeGCMCipherException(this.formatStrLocaleSafe("updateAAd: DataLen = %d", dataLength));
        }
    }

    public void encryptFinal(byte[] tag, int tagLen) throws NativeGCMCipherException {
        Assertions.checkState(this.mCurrentState == STATE.ENCRYPT_INITIALIZED, CIPHER_NOT_INIT);
        this.mCurrentState = STATE.ENCRYPT_FINALIZED;
        if (this.nativeEncryptFinal(tag, tagLen) == NativeGCMCipher.nativeFailure()) {
            throw new NativeGCMCipherException(this.formatStrLocaleSafe("encryptFinal: %d", tagLen));
        }
    }

    public void decryptFinal(byte[] expectedTag, int tagLen) throws NativeGCMCipherException {
        Assertions.checkState(this.mCurrentState == STATE.DECRYPT_INITIALIZED, CIPHER_NOT_INIT);
        this.mCurrentState = STATE.DECRYPT_FINALIZED;
        if (this.nativeDecryptFinal(expectedTag, tagLen) == NativeGCMCipher.nativeFailure()) {
            throw new NativeGCMCipherException("The message could not be decrypted successfully.It has either been tampered with or the wrong resource is being decrypted.");
        }
    }

    public void destroy() throws NativeGCMCipherException {
        this.ensureInFinalizedState();
        if (this.nativeDestroy() == NativeGCMCipher.nativeFailure()) {
            throw new NativeGCMCipherException("destroy");
        }
        this.mCurrentState = STATE.UNINITIALIZED;
    }

    public int getCipherBlockSize() {
        this.ensureInInitalizedState();
        return this.nativeGetCipherBlockSize();
    }

    private void ensureInInitalizedState() {
        boolean initialized = this.mCurrentState == STATE.DECRYPT_INITIALIZED || this.mCurrentState == STATE.ENCRYPT_INITIALIZED;
        Assertions.checkState(initialized, CIPHER_NOT_INIT);
    }

    private void ensureInFinalizedState() {
        boolean finalized = this.mCurrentState == STATE.DECRYPT_FINALIZED || this.mCurrentState == STATE.ENCRYPT_FINALIZED;
        Assertions.checkState(finalized, CIPHER_NOT_FINALIZED);
    }

    private String formatStrLocaleSafe(String format, Object ... args) {
        return String.format((Locale)null, format, args);
    }

    private static native int nativeFailure();

    private native int nativeEncryptInit(byte[] var1, byte[] var2);

    private native int nativeDecryptInit(byte[] var1, byte[] var2);

    private native int nativeUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    private native int nativeUpdateAad(byte[] var1, int var2);

    private native int nativeEncryptFinal(byte[] var1, int var2);

    private native int nativeDecryptFinal(byte[] var1, int var2);

    private native int nativeDestroy();

    private native int nativeGetCipherBlockSize();

    private static enum STATE {
        UNINITIALIZED,
        ENCRYPT_INITIALIZED,
        DECRYPT_INITIALIZED,
        ENCRYPT_FINALIZED,
        DECRYPT_FINALIZED;

    }
}

