/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto;

import com.facebook.crypto.CryptoAlgo;
import com.facebook.crypto.CryptoConfig;
import com.facebook.crypto.Entity;
import com.facebook.crypto.cipher.NativeGCMCipher;
import com.facebook.crypto.cipher.NativeGCMCipherException;
import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.streams.NativeGCMCipherInputStream;
import com.facebook.crypto.streams.NativeGCMCipherOutputStream;
import com.facebook.crypto.util.Assertions;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CryptoAlgoGcm
implements CryptoAlgo {
    private final NativeCryptoLibrary mNativeLibrary;
    private final KeyChain mKeyChain;
    private final CryptoConfig mConfig;

    public CryptoAlgoGcm(NativeCryptoLibrary mNativeLibrary, KeyChain mKeyChain, CryptoConfig config) {
        this.mNativeLibrary = mNativeLibrary;
        this.mKeyChain = mKeyChain;
        this.mConfig = config;
    }

    @Override
    public OutputStream wrap(OutputStream cipherStream, Entity entity, byte[] buffer) throws IOException, CryptoInitializationException, KeyChainException {
        cipherStream.write(1);
        cipherStream.write(this.mConfig.cipherId);
        byte[] iv = this.mKeyChain.getNewIV();
        NativeGCMCipher gcmCipher = new NativeGCMCipher(this.mNativeLibrary);
        gcmCipher.encryptInit(this.mKeyChain.getCipherKey(), iv);
        cipherStream.write(iv);
        byte[] entityBytes = entity.getBytes();
        this.computeCipherAad(gcmCipher, (byte)1, this.mConfig.cipherId, entityBytes);
        return new NativeGCMCipherOutputStream(cipherStream, gcmCipher, buffer, this.mConfig.tagLength);
    }

    @Override
    public InputStream wrap(InputStream is, Entity entity) throws IOException, CryptoInitializationException, KeyChainException {
        byte cryptoVersion = (byte)is.read();
        byte cipherID = (byte)is.read();
        Assertions.checkArgumentForIO(cryptoVersion == 1, "Unexpected crypto version " + cryptoVersion);
        Assertions.checkArgumentForIO(cipherID == this.mConfig.cipherId, "Unexpected cipher ID " + cipherID);
        byte[] iv = new byte[this.mConfig.ivLength];
        new DataInputStream(is).readFully(iv);
        NativeGCMCipher gcmCipher = new NativeGCMCipher(this.mNativeLibrary);
        gcmCipher.decryptInit(this.mKeyChain.getCipherKey(), iv);
        byte[] entityBytes = entity.getBytes();
        this.computeCipherAad(gcmCipher, cryptoVersion, cipherID, entityBytes);
        return new NativeGCMCipherInputStream(is, gcmCipher, this.mConfig.tagLength);
    }

    private void computeCipherAad(NativeGCMCipher gcmCipher, byte cryptoVersion, byte cipherID, byte[] entityBytes) throws NativeGCMCipherException {
        byte[] cryptoVersionBytes = new byte[]{cryptoVersion};
        byte[] cipherIDBytes = new byte[]{cipherID};
        gcmCipher.updateAad(cryptoVersionBytes, 1);
        gcmCipher.updateAad(cipherIDBytes, 1);
        gcmCipher.updateAad(entityBytes, entityBytes.length);
    }

    @Override
    public int getCipherMetaDataLength() {
        return 2 + this.mConfig.ivLength + this.mConfig.tagLength;
    }
}

