/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto;

import com.facebook.crypto.Crypto;
import com.facebook.crypto.CryptoConfig;
import com.facebook.crypto.keychain.KeyChain;
import com.facebook.crypto.keygen.PasswordBasedKeyDerivation;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.security.SecureRandom;

public abstract class Conceal {
    public final NativeCryptoLibrary nativeLibrary;
    public final SecureRandom secureRandom;

    protected Conceal(NativeCryptoLibrary nativeLibrary, SecureRandom secureRandom) {
        this.nativeLibrary = nativeLibrary;
        this.secureRandom = secureRandom;
    }

    public Crypto createDefaultCrypto(KeyChain keyChain) {
        return this.createCrypto256Bits(keyChain);
    }

    public Crypto createCrypto128Bits(KeyChain keyChain128Bits) {
        return new Crypto(keyChain128Bits, this.nativeLibrary, CryptoConfig.KEY_128);
    }

    public Crypto createCrypto256Bits(KeyChain keyChain256Bits) {
        return new Crypto(keyChain256Bits, this.nativeLibrary, CryptoConfig.KEY_256);
    }

    public PasswordBasedKeyDerivation createPasswordBasedKeyDerivation() {
        return new PasswordBasedKeyDerivation(this.secureRandom, this.nativeLibrary);
    }
}

