/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.android.crypto.keychain;

import android.os.Build;
import android.os.Process;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;

public class SecureRandomFix {
    private static final int VERSION_CODE_JELLY_BEAN = 17;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    private static final String DEV_URANDOM = "/dev/urandom";
    private static boolean sFixApplied;

    public static synchronized void tryApplyFixes() throws FixException {
        if (sFixApplied) {
            return;
        }
        try {
            SecureRandomFix.tryApplyOpenSSLFix();
            SecureRandomFix.tryInstallLinuxPRNGSecureRandom();
        }
        catch (Throwable t) {
            throw new FixException(t);
        }
        sFixApplied = true;
    }

    private static void tryApplyOpenSSLFix() {
        if (Build.VERSION.SDK_INT < 17 || Build.VERSION.SDK_INT > 18) {
            return;
        }
        try {
            Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, new Object[]{SecureRandomFix.generateSeed()});
            int bytesRead = (Integer)Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, DEV_URANDOM, 1024);
            if (bytesRead != 1024) {
                throw new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
            }
        }
        catch (Exception e) {
            throw new SecurityException("Failed to seed OpenSSL PRNG", e);
        }
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(SecureRandomFix.getBuildFingerprintAndDeviceSerial());
            seedBufferOut.close();
            return seedBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    private static byte[] getBuildFingerprintAndDeviceSerial() {
        String serial;
        StringBuilder result = new StringBuilder();
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint != null) {
            result.append(fingerprint);
        }
        if ((serial = SecureRandomFix.getDeviceSerialNumber()) != null) {
            result.append(serial);
        }
        try {
            return result.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    private static String getDeviceSerialNumber() {
        try {
            return (String)Build.class.getField("SERIAL").get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void tryInstallLinuxPRNGSecureRandom() throws SecurityException {
        SecureRandom rng2;
        SecureRandom rng1;
        if (Build.VERSION.SDK_INT > 18) {
            return;
        }
        Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
        if (secureRandomProviders == null || secureRandomProviders.length < 1 || !LinuxPRNGSecureRandomProvider.class.equals(secureRandomProviders[0].getClass())) {
            Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals((rng1 = new SecureRandom()).getProvider().getClass())) {
            throw new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
        }
        try {
            rng2 = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("SHA1PRNG not available", e);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals(rng2.getProvider().getClass())) {
            throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
        }
    }

    public static class LinuxPRNGSecureRandom
    extends SecureRandomSpi {
        private static final File URANDOM_FILE = new File("/dev/urandom");
        private static final Object sLock = new Object();
        private static DataInputStream sUrandomIn;
        private static OutputStream sUrandomOut;
        private boolean mSeedAttempted;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] bytes) {
            try {
                OutputStream out;
                Object object = sLock;
                synchronized (object) {
                    out = this.getUrandomOutputStream();
                }
                out.write(bytes);
                out.flush();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.mSeedAttempted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes) {
            if (!this.mSeedAttempted) {
                this.engineSetSeed(SecureRandomFix.generateSeed());
            }
            try {
                DataInputStream in;
                Object object = sLock;
                synchronized (object) {
                    in = this.getUrandomInputStream();
                }
                object = in;
                synchronized (object) {
                    in.readFully(bytes);
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int size) {
            byte[] seed = new byte[size];
            this.engineNextBytes(seed);
            return seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataInputStream getUrandomInputStream() {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                    }
                }
                return sUrandomIn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream getUrandomOutputStream() {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomOut == null) {
                    try {
                        sUrandomOut = new FileOutputStream(URANDOM_FILE);
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for writing", e);
                    }
                }
                return sUrandomOut;
            }
        }
    }

    private static class LinuxPRNGSecureRandomProvider
    extends Provider {
        public LinuxPRNGSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }

    public static class FixException
    extends RuntimeException {
        public FixException(Throwable throwable) {
            super("Error fixing the Android's SecureRandom", throwable);
        }
    }
}

