/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.params.DSAParameterGenerationParameters;
import org.spongycastle.crypto.params.DSAParameters;
import org.spongycastle.crypto.params.DSAValidationParameters;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.BigIntegers;
import org.spongycastle.util.encoders.Hex;

public class DSAParametersGenerator {
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private boolean use186_3;
    private int usageIndex;

    public DSAParametersGenerator() {
        this(new SHA1Digest());
    }

    public DSAParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(int size, int certainty, SecureRandom random) {
        this.use186_3 = false;
        this.L = size;
        this.N = DSAParametersGenerator.getDefaultN(size);
        this.certainty = certainty;
        this.random = random;
    }

    public void init(DSAParameterGenerationParameters params) {
        this.use186_3 = true;
        this.L = params.getL();
        this.N = params.getN();
        this.certainty = params.getCertainty();
        this.random = params.getRandom();
        this.usageIndex = params.getUsageIndex();
        if (this.L < 1024 || this.L > 3072 || this.L % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (this.L == 1024 && this.N != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (this.L == 2048 && this.N != 224 && this.N != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (this.L == 3072 && this.N != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < this.N) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
    }

    public DSAParameters generateParameters() {
        return this.use186_3 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_2() {
        seed = new byte[20];
        part1 = new byte[20];
        part2 = new byte[20];
        u = new byte[20];
        n = (this.L - 1) / 160;
        w = new byte[this.L / 8];
        if (!(this.digest instanceof SHA1Digest)) {
            throw new IllegalStateException("can only use SHA-1 for generating FIPS 186-2 parameters");
        }
        block0: while (true) {
            this.random.nextBytes(seed);
            DSAParametersGenerator.hash(this.digest, seed, part1);
            System.arraycopy(seed, 0, part2, 0, seed.length);
            DSAParametersGenerator.inc(part2);
            DSAParametersGenerator.hash(this.digest, part2, part2);
            for (i = 0; i != u.length; ++i) {
                u[i] = (byte)(part1[i] ^ part2[i]);
            }
            u[0] = (byte)(u[0] | -128);
            u[19] = (byte)(u[19] | 1);
            q = new BigInteger(1, u);
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            DSAParametersGenerator.inc(offset);
            counter = 0;
            while (true) {
                if (counter < 4096) ** break;
                continue block0;
                for (k = 0; k < n; ++k) {
                    DSAParametersGenerator.inc(offset);
                    DSAParametersGenerator.hash(this.digest, offset, part1);
                    System.arraycopy(part1, 0, w, w.length - (k + 1) * part1.length, part1.length);
                }
                DSAParametersGenerator.inc(offset);
                DSAParametersGenerator.hash(this.digest, offset, part1);
                System.arraycopy(part1, part1.length - (w.length - n * part1.length), w, 0, w.length - n * part1.length);
                w[0] = (byte)(w[0] | -128);
                x = new BigInteger(1, w);
                c = x.mod(q.shiftLeft(1));
                p = x.subtract(c.subtract(DSAParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    g = DSAParametersGenerator.calculateGenerator_FIPS186_2(p, q, this.random);
                    return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger p, BigInteger q, SecureRandom r) {
        BigInteger h;
        BigInteger g;
        BigInteger e = p.subtract(ONE).divide(q);
        BigInteger pSub2 = p.subtract(TWO);
        while ((g = (h = BigIntegers.createRandomInRange(TWO, pSub2, r)).modPow(e, p)).bitLength() <= 1) {
        }
        return g;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_3() {
        d = this.digest;
        outlen = d.getDigestSize() * 8;
        seedlen = this.N;
        seed = new byte[seedlen / 8];
        n = (this.L - 1) / outlen;
        b = (this.L - 1) % outlen;
        output = new byte[d.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(seed);
            DSAParametersGenerator.hash(d, seed, output);
            U = new BigInteger(1, output).mod(DSAParametersGenerator.ONE.shiftLeft(this.N - 1));
            q = DSAParametersGenerator.ONE.shiftLeft(this.N - 1).add(U).add(DSAParametersGenerator.ONE).subtract(U.mod(DSAParametersGenerator.TWO));
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            counterLimit = 4 * this.L;
            counter = 0;
            while (true) {
                if (counter < counterLimit) ** break;
                continue block0;
                W = DSAParametersGenerator.ZERO;
                j = 0;
                exp = 0;
                while (j <= n) {
                    DSAParametersGenerator.inc(offset);
                    DSAParametersGenerator.hash(d, offset, output);
                    Vj = new BigInteger(1, output);
                    if (j == n) {
                        Vj = Vj.mod(DSAParametersGenerator.ONE.shiftLeft(b));
                    }
                    W = W.add(Vj.shiftLeft(exp));
                    ++j;
                    exp += outlen;
                }
                X = W.add(DSAParametersGenerator.ONE.shiftLeft(this.L - 1));
                p = X.subtract((c = X.mod(q.shiftLeft(1))).subtract(DSAParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    if (this.usageIndex >= 0 && (g = DSAParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(d, p, q, seed, this.usageIndex)) != null) {
                        return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter, this.usageIndex));
                    }
                    g = DSAParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(p, q, this.random);
                    return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger p, BigInteger q, SecureRandom r) {
        return DSAParametersGenerator.calculateGenerator_FIPS186_2(p, q, r);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest d, BigInteger p, BigInteger q, byte[] seed, int index) {
        BigInteger e = p.subtract(ONE).divide(q);
        byte[] ggen = Hex.decode("6767656E");
        byte[] U = new byte[seed.length + ggen.length + 1 + 2];
        System.arraycopy(seed, 0, U, 0, seed.length);
        System.arraycopy(ggen, 0, U, seed.length, ggen.length);
        U[U.length - 3] = (byte)index;
        byte[] w = new byte[d.getDigestSize()];
        for (int count = 1; count < 65536; ++count) {
            DSAParametersGenerator.inc(U);
            DSAParametersGenerator.hash(d, U, w);
            BigInteger W = new BigInteger(1, w);
            BigInteger g = W.modPow(e, p);
            if (g.compareTo(TWO) < 0) continue;
            return g;
        }
        return null;
    }

    private static void hash(Digest d, byte[] input, byte[] output) {
        d.update(input, 0, input.length);
        d.doFinal(output, 0);
    }

    private static int getDefaultN(int L) {
        return L > 1024 ? 256 : 160;
    }

    private static void inc(byte[] buf) {
        for (int i = buf.length - 1; i >= 0; --i) {
            byte b;
            buf[i] = b = (byte)(buf[i] + 1 & 0xFF);
            if (b != 0) break;
        }
    }
}

