/*
 * Decompiled with CFR 0.152.
 */
package network.pocket.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import network.pocket.core.errors.PocketError;
import network.pocket.core.model.Blockchain;
import network.pocket.core.model.Configuration;
import network.pocket.core.model.Dispatch;
import network.pocket.core.model.Node;
import network.pocket.core.model.Relay;
import network.pocket.core.net.PocketAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J^\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00132:\u0010\u0014\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0015\u0012\u0013\u0018\u00010\u001a\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001eH\u0002JJ\u0010\u0012\u001a\u00020\u000f2@\u0010\u0014\u001a<\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001e\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u009e\u0001\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010%2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010%2:\u0010\u0014\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016JJ\u0010\u001f\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2:\u0010\u0014\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u000f0\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnetwork/pocket/core/Pocket;", "", "devID", "", "network", "netIds", "", "maxNodes", "", "requestTimeOut", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;II)V", "dispatch", "Lnetwork/pocket/core/model/Dispatch;", "[Ljava/lang/String;", "addBlockchain", "", "netID", "getNode", "retrieveNodes", "", "callback", "Lkotlin/Function2;", "Lnetwork/pocket/core/errors/PocketError;", "Lkotlin/ParameterName;", "name", "error", "Lnetwork/pocket/core/model/Node;", "node", "getRandomNode", "nodes", "", "send", "blockchain", "data", "method", "path", "queryParams", "", "headers", "relay", "Lnetwork/pocket/core/model/Relay;", "pocket-android-core_release"})
public abstract class Pocket {
    private final Dispatch dispatch;
    private final String devID;
    private final String[] netIds;
    private final int maxNodes;
    private final int requestTimeOut;

    public final void send(@NotNull Relay relay, @NotNull Function2<? super PocketError, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)relay, (String)"relay");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (!relay.isValid()) {
            callback.invoke((Object)new PocketError("Relay is missing a property, please verify all properties."), null);
            return;
        }
        this.getNode(relay.getBlockchain(), relay.getNetId(), true, (Function2<? super PocketError, ? super Node, Unit>)((Function2)new Function2<PocketError, Node, Unit>(callback, relay){
            final /* synthetic */ Function2 $callback;
            final /* synthetic */ Relay $relay;

            public final void invoke(@Nullable PocketError pocketError, @Nullable Node node) {
                PocketError pocketError2 = pocketError;
                if (pocketError2 != null) {
                    PocketError pocketError3;
                    PocketError pocketError4 = pocketError3 = pocketError2;
                    boolean bl = false;
                    this.$callback.invoke((Object)pocketError4, null);
                    return;
                }
                Node node2 = node;
                if (node2 != null) {
                    Node node3;
                    Node node4 = node3 = node2;
                    boolean bl = false;
                    PocketAPI.Companion.send(this.$relay, node4, (Function2<? super PocketError, ? super String, Unit>)this.$callback);
                    return;
                }
                this.$callback.invoke((Object)new PocketError("No nodes available for " + this.$relay.getBlockchain() + " - " + this.$relay.getNetId()), null);
            }
            {
                this.$callback = function2;
                this.$relay = relay;
                super(2);
            }
        }));
    }

    public void send(@NotNull String blockchain, @NotNull String netID, @Nullable String data, @Nullable String method, @Nullable String path, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers, @NotNull Function2<? super PocketError, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)blockchain, (String)"blockchain");
        Intrinsics.checkParameterIsNotNull((Object)netID, (String)"netID");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.send(new Relay(blockchain, netID, this.dispatch.getConfiguration().getDevId(), data, method, path, queryParams, headers), callback);
    }

    public final void addBlockchain(@NotNull String network, @NotNull String netID) {
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        Intrinsics.checkParameterIsNotNull((Object)netID, (String)"netID");
        this.dispatch.getConfiguration().getBlockChains().add(new Blockchain(network, netID));
    }

    private final Node getRandomNode(List<Node> nodes) {
        Node node;
        List<Node> list = nodes;
        if (list == null) {
            return null;
        }
        switch (nodes.size()) {
            case 0: {
                node = null;
                break;
            }
            case 1: {
                node = (Node)CollectionsKt.first(nodes);
                break;
            }
            default: {
                Collection collection = nodes;
                int n = 0;
                List<Node> list2 = nodes;
                int n2 = collection.size();
                collection = RangesKt.until((int)n, (int)(n2 - 1));
                n = RangesKt.random((IntRange)collection, (Random)((Random)Random.Default));
                node = list2.get(n);
            }
        }
        return node;
    }

    private final void getNode(String network, String netID, boolean retrieveNodes2, Function2<? super PocketError, ? super Node, Unit> callback) {
        ArrayList<Node> arrayList;
        ArrayList<Node> nodes = arrayList = new ArrayList<Node>();
        Iterable $receiver$iv = this.dispatch.getNodes();
        for (Object element$iv : $receiver$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            if (!node.isEqual(netID, network)) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty() && retrieveNodes2) {
            this.retrieveNodes((Function2<? super PocketError, ? super List<Node>, Unit>)((Function2)new Function2<PocketError, List<? extends Node>, Unit>(this, callback){
                final /* synthetic */ Pocket this$0;
                final /* synthetic */ Function2 $callback;

                public final void invoke(@Nullable PocketError error, @Nullable List<Node> nodes) {
                    PocketError pocketError = error;
                    if (pocketError != null) {
                        PocketError pocketError2;
                        PocketError pocketError3 = pocketError2 = pocketError;
                        boolean bl = false;
                        this.$callback.invoke((Object)pocketError3, null);
                        return;
                    }
                    List<Node> list = nodes;
                    if (list != null) {
                        List<Node> list2;
                        List<Node> nodeList = list2 = list;
                        boolean bl = false;
                        this.$callback.invoke(null, (Object)Pocket.access$getRandomNode(this.this$0, nodeList));
                        return;
                    }
                    this.$callback.invoke((Object)new PocketError("Unknown error fetching nodes"), null);
                }
                {
                    this.this$0 = pocket;
                    this.$callback = function2;
                    super(2);
                }
            }));
        } else {
            callback.invoke(null, (Object)this.getRandomNode((List<Node>)nodes));
        }
    }

    static /* synthetic */ void getNode$default(Pocket pocket, String string, String string2, boolean bl, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNode");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        pocket.getNode(string, string2, bl, (Function2<? super PocketError, ? super Node, Unit>)function2);
    }

    private final void retrieveNodes(Function2<? super PocketError, ? super List<Node>, Unit> callback) {
        PocketAPI.Companion.retrieveNodes(this.dispatch.getConfiguration(), (Function2<? super PocketError, ? super JSONArray, Unit>)((Function2)new Function2<PocketError, JSONArray, Unit>(this, callback){
            final /* synthetic */ Pocket this$0;
            final /* synthetic */ Function2 $callback;

            public final void invoke(@Nullable PocketError error, @Nullable JSONArray nodesJSON) {
                PocketError pocketError = error;
                List nodeList = null;
                try {
                    Dispatch dispatch = Pocket.access$getDispatch$p(this.this$0);
                    JSONArray jSONArray = nodesJSON;
                    if (jSONArray == null) {
                        jSONArray = new JSONArray();
                    }
                    nodeList = dispatch.parseDispatchResponse(jSONArray);
                }
                catch (PocketError error2) {
                    pocketError = error2;
                    nodeList = new ArrayList<E>();
                }
                this.$callback.invoke((Object)pocketError, (Object)nodeList);
            }
            {
                this.this$0 = pocket;
                this.$callback = function2;
                super(2);
            }
        }));
    }

    public Pocket(@NotNull String devID, @NotNull String network, @NotNull String[] netIds, int maxNodes, int requestTimeOut) {
        String[] $receiver$iv;
        ArrayList<Blockchain> arrayList;
        Intrinsics.checkParameterIsNotNull((Object)devID, (String)"devID");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        Intrinsics.checkParameterIsNotNull((Object)netIds, (String)"netIds");
        ArrayList<Blockchain> blockchains = arrayList = new ArrayList<Blockchain>();
        String[] stringArray = $receiver$iv = netIds;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String netId = element$iv = stringArray[i];
            boolean bl = false;
            blockchains.add(new Blockchain(network, netId));
        }
        this.dispatch = new Dispatch(new Configuration(devID, blockchains, maxNodes, requestTimeOut));
        this.devID = devID;
        this.netIds = netIds;
        this.maxNodes = maxNodes;
        this.requestTimeOut = requestTimeOut;
    }

    public /* synthetic */ Pocket(String string, String string2, String[] stringArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n = 5;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 1000;
        }
        this(string, string2, stringArray, n, n2);
    }

    public static final /* synthetic */ Node access$getRandomNode(Pocket $this, List nodes) {
        return $this.getRandomNode(nodes);
    }

    public static final /* synthetic */ Dispatch access$getDispatch$p(Pocket $this) {
        return $this.dispatch;
    }
}

