/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.symmetric;

import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ju\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n26\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/pvryan/easycrypt/symmetric/performEncrypt;", "", "()V", "invoke", "", "T", "input", "password", "", "cipher", "Ljavax/crypto/Cipher;", "getKey", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "", "salt", "Ljavax/crypto/spec/SecretKeySpec;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "invoke$easycrypt_release", "(Ljava/lang/Object;Ljava/lang/String;Ljavax/crypto/Cipher;Lkotlin/jvm/functions/Function2;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "easycrypt_release"})
public final class performEncrypt {
    public static final performEncrypt INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final /* synthetic */ <T> void invoke$easycrypt_release(T input, @NotNull String password, @NotNull Cipher cipher, @NotNull Function2<? super String, ? super byte[], ? extends SecretKeySpec> getKey, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        Intrinsics.checkParameterIsNotNull(getKey, (String)"getKey");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        if (outputFile.exists() && Intrinsics.areEqual((Object)outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ^ true) {
            T t = input;
            if (t instanceof InputStream) {
                ((InputStream)input).close();
            }
            erl.onFailure("Output file already exists.", (Exception)new FileAlreadyExistsException(outputFile, null, null, 6, null));
            return;
        }
        byte[] salt = new byte[32];
        Constants.Companion.getRandom().nextBytes(salt);
        SecretKeySpec keySpec = (SecretKeySpec)getKey.invoke((Object)password, (Object)salt);
        byte[] iv = new byte[cipher.getBlockSize()];
        Constants.Companion.getRandom().nextBytes(iv);
        IvParameterSpec ivParams = new IvParameterSpec(iv);
        cipher.init(1, (Key)keySpec, ivParams);
        T t = input;
        if (t instanceof byte[]) {
            byte[] byArray = ArraysKt.plus((byte[])iv, (byte[])salt);
            byte[] byArray2 = cipher.doFinal((byte[])input);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"cipher.doFinal(input)");
            DataTypeExtensionsKt.handleSuccess(ArraysKt.plus((byte[])byArray, (byte[])byArray2), erl, outputFile, true);
        } else if (t instanceof FileInputStream) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            File file = outputFile;
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(iv);
                fos.write(salt);
            }
            catch (IOException e) {
                fos.flush();
                fos.close();
                ((FileInputStream)input).close();
                outputFile.delete();
                erl.onFailure("Cannot write to file.", e);
                return;
            }
            CipherOutputStream cos = new CipherOutputStream(fos, cipher);
            try {
                long size = ((FileInputStream)input).getChannel().size();
                byte[] buffer = new byte[8192];
                long bytesCopied = 0L;
                int read = ((FileInputStream)input).read(buffer);
                while (read > -1) {
                    cos.write(buffer, 0, read);
                    erl.onProgress(read, bytesCopied += (long)read, size);
                    read = ((FileInputStream)input).read(buffer);
                }
            }
            catch (IOException e) {
                outputFile.delete();
                erl.onFailure("Cannot write to file.", e);
                return;
            }
            finally {
                cos.flush();
                cos.close();
                ((FileInputStream)input).close();
            }
            erl.onSuccess(outputFile);
        } else {
            erl.onFailure("Input type not supported.", new InvalidParameterException());
        }
    }

    private performEncrypt() {
    }

    static {
        performEncrypt performEncrypt2;
        INSTANCE = performEncrypt2 = new performEncrypt();
    }
}

