/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.extensions;

import android.util.Base64;
import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.interfaces.RSAKey;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0007\u001a\n\u0010\n\u001a\u00020\t*\u00020\b\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\b\u001a\f\u0010\f\u001a\u00020\b*\u00020\tH\u0007\u001a\"\u0010\r\u001a\u00020\u000e*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\tH\u0007\u001a\n\u0010\u0016\u001a\u00020\u0014*\u00020\t\u001a\n\u0010\u0017\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0018\u001a\u00020\b*\u00020\b\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"HEX_CHARS", "", "pHex", "Ljava/util/regex/Pattern;", "allowedInputSize", "", "Ljava/security/interfaces/RSAKey;", "asByteArray", "", "", "asHexString", "asString", "fromBase64", "handleSuccess", "", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "asBase64String", "", "hexToByteArray", "isValidHex", "size", "toBase64", "toBase64String", "easycrypt_release"})
public final class DataTypeExtensionsKt {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern pHex;

    @NotNull
    public static final String toBase64String(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = Base64.encodeToString((byte[])$receiver, (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.encodeToString(this, Base64.URL_SAFE)");
        return string;
    }

    @NotNull
    public static final byte[] toBase64(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = Base64.encode((byte[])$receiver, (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.encode(this, Base64.URL_SAFE)");
        return byArray;
    }

    @NotNull
    public static final String asString(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = $receiver;
        Charset charset = Charsets.UTF_8;
        return new String(byArray, charset);
    }

    @NotNull
    public static final String asHexString(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuffer result = new StringBuffer();
        byte[] $receiver$iv = $receiver;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte it;
            byte octet = it = (element$iv = $receiver$iv[i]);
            int firstIndex = (octet & 0xF0) >>> 4;
            int secondIndex = octet & 0xF;
            result.append(HEX_CHARS[firstIndex]);
            result.append(HEX_CHARS[secondIndex]);
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void handleSuccess(@NotNull byte[] $receiver, @NotNull ECResultListener erl, @NotNull File outputFile, boolean asBase64String) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        if (Intrinsics.areEqual((Object)outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_ENCRYPTED_FILE_PATH()) ^ true && Intrinsics.areEqual((Object)outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_DECRYPTED_FILE_PATH()) ^ true) {
            try {
                Object object = outputFile;
                object = new FileOutputStream((File)object);
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)object;
                    if (asBase64String) {
                        it.write(DataTypeExtensionsKt.toBase64($receiver));
                    } else {
                        it.write($receiver);
                    }
                    it.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                erl.onSuccess(outputFile);
            }
            catch (IOException e) {
                erl.onFailure("Cannot write to file.", e);
            }
        } else if (asBase64String) {
            erl.onSuccess(DataTypeExtensionsKt.toBase64String($receiver));
        } else {
            erl.onSuccess(DataTypeExtensionsKt.asString($receiver));
        }
    }

    @NotNull
    public static final byte[] asByteArray(@NotNull String $receiver) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static final byte[] fromBase64(@NotNull String $receiver) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = Base64.decode((byte[])DataTypeExtensionsKt.asByteArray($receiver), (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(this.asByteArray(), Base64.URL_SAFE)");
        return byArray;
    }

    public static final boolean isValidHex(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.length() % 2 == 0 && pHex.matcher($receiver).matches();
    }

    @NotNull
    public static final byte[] hexToByteArray(@NotNull String $receiver) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String trimmed = StringsKt.replace$default((String)$receiver, (String)" ", (String)"", (boolean)false, (int)4, null);
        if (!DataTypeExtensionsKt.isValidHex(trimmed)) {
            throw (Throwable)new IllegalArgumentException("Invalid hex string.");
        }
        byte[] data = new byte[trimmed.length() / 2];
        for (int i = 0; i < trimmed.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(trimmed.charAt(i), 16) << 4) + Character.digit(trimmed.charAt(i + 1), 16));
        }
        return data;
    }

    public static final int size(@NotNull RSAKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModulus().bitLength();
    }

    public static final int allowedInputSize(@NotNull RSAKey $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        double keyLength = DataTypeExtensionsKt.size($receiver);
        int hashOutputLength = 256;
        return (int)(Math.floor(keyLength / (double)8) - (double)(2 * (hashOutputLength / 8)) - (double)2);
    }

    static {
        Pattern pattern = Pattern.compile("[0-9a-fA-F]+");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"[0-9a-fA-F]+\")");
        pHex = pattern;
    }
}

