/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto;

import com.facebook.crypto.CryptoConfig;
import com.facebook.crypto.exception.KeyChainException;
import com.facebook.crypto.keychain.KeyChain;

class CheckedKeyChain
implements KeyChain {
    private final KeyChain mDelegate;
    private final CryptoConfig mConfig;

    public CheckedKeyChain(KeyChain mDelegate, CryptoConfig mConfig) {
        this.mDelegate = mDelegate;
        this.mConfig = mConfig;
    }

    @Override
    public byte[] getCipherKey() throws KeyChainException {
        byte[] result = this.mDelegate.getCipherKey();
        this.checkLength(result, this.mConfig.keyLength, "Key");
        return result;
    }

    @Override
    public byte[] getMacKey() throws KeyChainException {
        byte[] result = this.mDelegate.getMacKey();
        this.checkLength(result, 64, "Mac");
        return result;
    }

    @Override
    public byte[] getNewIV() throws KeyChainException {
        byte[] result = this.mDelegate.getNewIV();
        this.checkLength(result, this.mConfig.ivLength, "IV");
        return result;
    }

    @Override
    public void destroyKeys() {
        this.mDelegate.destroyKeys();
    }

    private void checkLength(byte[] key, int lengthInBytes, String name) {
        if (key.length != lengthInBytes) {
            throw new IllegalStateException(name + " should be " + lengthInBytes + " bytes long but is " + key.length);
        }
    }
}

