/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.connections;

import com.subgraph.orchid.BridgeRouter;
import com.subgraph.orchid.Cell;
import com.subgraph.orchid.ConnectionHandshakeException;
import com.subgraph.orchid.ConnectionIOException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.cells.CellImpl;
import com.subgraph.orchid.connections.ConnectionHandshakeV2;
import com.subgraph.orchid.connections.ConnectionHandshakeV3;
import com.subgraph.orchid.connections.ConnectionImpl;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.IPv4Address;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;

public abstract class ConnectionHandshake {
    private static final Logger logger = Logger.getLogger(ConnectionHandshake.class.getName());
    protected final ConnectionImpl connection;
    protected final SSLSocket socket;
    protected final List<Integer> remoteVersions;
    private int remoteTimestamp;
    private IPv4Address myAddress;
    private final List<IPv4Address> remoteAddresses;

    static ConnectionHandshake createHandshake(TorConfig config, ConnectionImpl connection, SSLSocket socket) throws ConnectionHandshakeException {
        if (config.getHandshakeV3Enabled() && ConnectionHandshakeV3.sessionSupportsHandshake(socket.getSession())) {
            return new ConnectionHandshakeV3(connection, socket);
        }
        if (config.getHandshakeV2Enabled()) {
            return new ConnectionHandshakeV2(connection, socket);
        }
        throw new ConnectionHandshakeException("No valid handshake type available for this connection");
    }

    ConnectionHandshake(ConnectionImpl connection, SSLSocket socket) {
        this.connection = connection;
        this.socket = socket;
        this.remoteVersions = new ArrayList<Integer>();
        this.remoteAddresses = new ArrayList<IPv4Address>();
    }

    abstract void runHandshake() throws IOException, InterruptedException, ConnectionIOException;

    int getRemoteTimestamp() {
        return this.remoteTimestamp;
    }

    IPv4Address getMyAddress() {
        return this.myAddress;
    }

    protected Cell expectCell(Integer ... expectedTypes) throws ConnectionHandshakeException {
        try {
            Cell c = this.connection.readConnectionControlCell();
            Integer[] integerArray = expectedTypes;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int t = integerArray[i];
                if (c.getCommand() != t) continue;
                return c;
            }
            List<Integer> expected = Arrays.asList(expectedTypes);
            throw new ConnectionHandshakeException("Expecting Cell command " + expected + " and got [ " + c.getCommand() + " ] instead");
        }
        catch (ConnectionIOException e) {
            throw new ConnectionHandshakeException("Connection exception while performing handshake " + e);
        }
    }

    protected void sendVersions(int ... versions) throws ConnectionIOException {
        CellImpl cell = CellImpl.createVarCell(0, 7, versions.length * 2);
        for (int v : versions) {
            cell.putShort(v);
        }
        this.connection.sendCell(cell);
    }

    protected void receiveVersions() throws ConnectionHandshakeException {
        Cell c = this.expectCell(7);
        while (c.cellBytesRemaining() >= 2) {
            this.remoteVersions.add(c.getShort());
        }
    }

    protected void sendNetinfo() throws ConnectionIOException {
        CellImpl cell = CellImpl.createCell(0, 8);
        this.putTimestamp(cell);
        this.putIPv4Address(cell, this.connection.getRouter().getAddress());
        this.putMyAddresses(cell);
        this.connection.sendCell(cell);
    }

    private void putTimestamp(Cell cell) {
        Date now = new Date();
        cell.putInt((int)(now.getTime() / 1000L));
    }

    private void putIPv4Address(Cell cell, IPv4Address address) {
        byte[] data = address.getAddressDataBytes();
        cell.putByte(4);
        cell.putByte(data.length);
        cell.putByteArray(data);
    }

    private void putMyAddresses(Cell cell) {
        cell.putByte(1);
        this.putIPv4Address(cell, new IPv4Address(0));
    }

    protected void recvNetinfo() throws ConnectionHandshakeException {
        this.processNetInfo(this.expectCell(8));
    }

    protected void processNetInfo(Cell netinfoCell) {
        this.remoteTimestamp = netinfoCell.getInt();
        this.myAddress = this.readAddress(netinfoCell);
        int addressCount = netinfoCell.getByte();
        for (int i = 0; i < addressCount; ++i) {
            IPv4Address addr = this.readAddress(netinfoCell);
            if (addr == null) continue;
            this.remoteAddresses.add(addr);
        }
    }

    private IPv4Address readAddress(Cell cell) {
        int type = cell.getByte();
        int len = cell.getByte();
        if (type == 4 && len == 4) {
            return new IPv4Address(cell.getInt());
        }
        byte[] buffer = new byte[len];
        cell.getByteArray(buffer);
        return null;
    }

    protected void verifyIdentityKey(PublicKey publicKey) throws ConnectionHandshakeException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new ConnectionHandshakeException("Identity certificate public key is not an RSA key as expected");
        }
        TorPublicKey identityKey = new TorPublicKey((RSAPublicKey)publicKey);
        Router router = this.connection.getRouter();
        if (router instanceof BridgeRouter && router.getIdentityHash() == null) {
            logger.info("Setting Bridge fingerprint from connection handshake for " + router);
            ((BridgeRouter)router).setIdentity(identityKey.getFingerprint());
        } else if (!identityKey.getFingerprint().equals(router.getIdentityHash())) {
            throw new ConnectionHandshakeException("Router identity does not match certificate key");
        }
    }
}

