/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import com.google.gson.Gson;
import com.orhanobut.hawk.ConcealEncryption;
import com.orhanobut.hawk.Converter;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.GsonParser;
import com.orhanobut.hawk.Hawk;
import com.orhanobut.hawk.HawkConverter;
import com.orhanobut.hawk.HawkSerializer;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.LogInterceptor;
import com.orhanobut.hawk.NoEncryption;
import com.orhanobut.hawk.Parser;
import com.orhanobut.hawk.Serializer;
import com.orhanobut.hawk.SharedPreferencesStorage;
import com.orhanobut.hawk.Storage;

public class HawkBuilder {
    private static final String STORAGE_TAG_DO_NOT_CHANGE = "Hawk2";
    private Context context;
    private Storage cryptoStorage;
    private Converter converter;
    private Parser parser;
    private Encryption encryption;
    private Serializer serializer;
    private LogInterceptor logInterceptor;

    public HawkBuilder(Context context) {
        HawkUtils.checkNull("Context", context);
        this.context = context.getApplicationContext();
    }

    public HawkBuilder setStorage(Storage storage) {
        this.cryptoStorage = storage;
        return this;
    }

    public HawkBuilder setParser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public HawkBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public HawkBuilder setLogInterceptor(LogInterceptor logInterceptor) {
        this.logInterceptor = logInterceptor;
        return this;
    }

    public HawkBuilder setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public HawkBuilder setEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    LogInterceptor getLogInterceptor() {
        if (this.logInterceptor == null) {
            this.logInterceptor = new LogInterceptor(){

                @Override
                public void onLog(String message) {
                }
            };
        }
        return this.logInterceptor;
    }

    Storage getStorage() {
        if (this.cryptoStorage == null) {
            this.cryptoStorage = new SharedPreferencesStorage(this.context, STORAGE_TAG_DO_NOT_CHANGE);
        }
        return this.cryptoStorage;
    }

    Converter getConverter() {
        if (this.converter == null) {
            this.converter = new HawkConverter(this.getParser());
        }
        return this.converter;
    }

    Parser getParser() {
        if (this.parser == null) {
            this.parser = new GsonParser(new Gson());
        }
        return this.parser;
    }

    Encryption getEncryption() {
        if (this.encryption == null) {
            this.encryption = new ConcealEncryption(this.context);
            if (!this.encryption.init()) {
                this.encryption = new NoEncryption();
            }
        }
        return this.encryption;
    }

    Serializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new HawkSerializer(this.getLogInterceptor());
        }
        return this.serializer;
    }

    public void build() {
        Hawk.build(this);
    }
}

