/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentImpl;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentParser;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentSectionParser;
import com.subgraph.orchid.directory.consensus.DocumentKeyword;
import com.subgraph.orchid.directory.consensus.RouterStatusImpl;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;

public class RouterStatusSectionParser
extends ConsensusDocumentSectionParser {
    private RouterStatusImpl currentEntry = null;

    RouterStatusSectionParser(DocumentFieldParser parser, ConsensusDocumentImpl document) {
        super(parser, document);
    }

    @Override
    void parseLine(DocumentKeyword keyword) {
        if (!keyword.equals((Object)DocumentKeyword.R)) {
            this.assertCurrentEntry();
        }
        switch (keyword) {
            case R: {
                this.parseFirstLine();
                break;
            }
            case S: {
                this.parseFlags();
                break;
            }
            case V: {
                this.parseVersion();
                break;
            }
            case W: {
                this.parseBandwidth();
                break;
            }
            case P: {
                this.parsePortList();
                break;
            }
            case M: {
                this.parseMicrodescriptorHash();
                break;
            }
        }
    }

    private void assertCurrentEntry() {
        if (this.currentEntry == null) {
            throw new TorParsingException("Router status entry must begin with an 'r' line");
        }
    }

    private void addCurrentEntry() {
        this.assertCurrentEntry();
        this.document.addRouterStatusEntry(this.currentEntry);
        this.currentEntry = null;
    }

    private void parseFirstLine() {
        if (this.currentEntry != null) {
            throw new TorParsingException("Unterminated router status entry.");
        }
        this.currentEntry = new RouterStatusImpl();
        this.currentEntry.setNickname(this.fieldParser.parseNickname());
        this.currentEntry.setIdentity(this.parseBase64Digest());
        if (this.document.getFlavor() != ConsensusDocument.ConsensusFlavor.MICRODESC) {
            this.currentEntry.setDigest(this.parseBase64Digest());
        }
        this.currentEntry.setPublicationTime(this.fieldParser.parseTimestamp());
        this.currentEntry.setAddress(this.fieldParser.parseAddress());
        this.currentEntry.setRouterPort(this.fieldParser.parsePort());
        this.currentEntry.setDirectoryPort(this.fieldParser.parsePort());
    }

    private HexDigest parseBase64Digest() {
        return HexDigest.createFromDigestBytes(this.fieldParser.parseBase64Data());
    }

    private void parseFlags() {
        while (this.fieldParser.argumentsRemaining() > 0) {
            this.currentEntry.addFlag(this.fieldParser.parseString());
        }
    }

    private void parseVersion() {
        this.currentEntry.setVersion(this.fieldParser.parseConcatenatedString());
    }

    private void parseBandwidth() {
        while (this.fieldParser.argumentsRemaining() > 0) {
            String[] parts = this.fieldParser.parseString().split("=");
            if (parts.length != 2) continue;
            this.parseBandwidthItem(parts[0], this.fieldParser.parseInteger(parts[1]));
        }
        if (this.document.getFlavor() == ConsensusDocument.ConsensusFlavor.MICRODESC) {
            this.addCurrentEntry();
        }
    }

    private void parseBandwidthItem(String key, int value) {
        if (key.equals("Bandwidth")) {
            this.currentEntry.setEstimatedBandwidth(value);
        } else if (key.equals("Measured")) {
            this.currentEntry.setMeasuredBandwidth(value);
        }
    }

    private void parsePortList() {
        if (this.document.getFlavor() == ConsensusDocument.ConsensusFlavor.MICRODESC) {
            throw new TorParsingException("'p' line does not appear in consensus flavor 'microdesc'");
        }
        String arg = this.fieldParser.parseString();
        if (arg.equals("accept")) {
            this.currentEntry.setAcceptedPorts(this.fieldParser.parseString());
        } else if (arg.equals("reject")) {
            this.currentEntry.setRejectedPorts(this.fieldParser.parseString());
        }
        this.addCurrentEntry();
    }

    private void parseMicrodescriptorHash() {
        if (this.document.getFlavor() != ConsensusDocument.ConsensusFlavor.MICRODESC) {
            throw new TorParsingException("'m' line is invalid unless consensus flavor is microdesc");
        }
        byte[] hashBytes = this.fieldParser.parseBase64Data();
        if (hashBytes.length != 32) {
            throw new TorParsingException("'m' line has incorrect digest size " + hashBytes.length + " != " + 32);
        }
        this.currentEntry.setMicrodescriptorDigest(HexDigest.createFromDigestBytes(hashBytes));
    }

    @Override
    String getNextStateKeyword() {
        return "directory-footer";
    }

    @Override
    ConsensusDocumentParser.DocumentSection getSection() {
        return ConsensusDocumentParser.DocumentSection.ROUTER_STATUS;
    }

    @Override
    ConsensusDocumentParser.DocumentSection nextSection() {
        return ConsensusDocumentParser.DocumentSection.FOOTER;
    }
}

