/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.dashboard;

import com.subgraph.orchid.Threading;
import com.subgraph.orchid.dashboard.DashboardConnection;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.misc.GuardedBy;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class Dashboard
implements DashboardRenderable,
DashboardRenderer {
    private static final Logger logger = Logger.getLogger(Dashboard.class.getName());
    private static final String DASHBOARD_PORT_PROPERTY = "com.subgraph.orchid.dashboard.port";
    private static final int DEFAULT_LISTENING_PORT = 12345;
    private static final int DEFAULT_FLAGS = 24;
    private static final IPv4Address LOCALHOST = IPv4Address.createFromString("127.0.0.1");
    @GuardedBy(value="this")
    private int listeningPort;
    @GuardedBy(value="this")
    private int flags = 24;
    @GuardedBy(value="this")
    private ServerSocket listeningSocket;
    @GuardedBy(value="this")
    private boolean isListening;
    private final List<DashboardRenderable> renderables = new CopyOnWriteArrayList<DashboardRenderable>();
    private final Executor executor;

    public Dashboard() {
        this.renderables.add(this);
        this.executor = Threading.newPool("Dashboard worker");
        this.listeningPort = Dashboard.chooseListeningPort();
    }

    private static int chooseListeningPort() {
        String dbPort = System.getProperty(DASHBOARD_PORT_PROPERTY);
        int port = Dashboard.parsePortProperty(dbPort);
        if (port > 0 && port <= 65535) {
            return port;
        }
        if (dbPort != null) {
            logger.warning("com.subgraph.orchid.dashboard.port was not a valid port value: " + dbPort);
        }
        return 12345;
    }

    private static int parsePortProperty(String dbPort) {
        if (dbPort == null) {
            return -1;
        }
        try {
            return Integer.parseInt(dbPort);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void addRenderables(Object ... objects) {
        for (Object ob : objects) {
            if (!(ob instanceof DashboardRenderable)) continue;
            this.renderables.add((DashboardRenderable)ob);
        }
    }

    public void addRenderable(DashboardRenderable renderable) {
        this.renderables.add(renderable);
    }

    public synchronized void enableFlag(int flag) {
        this.flags |= flag;
    }

    public synchronized void disableFlag(int flag) {
        this.flags &= ~flag;
    }

    public synchronized boolean isEnabled(int f) {
        return (this.flags & f) != 0;
    }

    public synchronized void setListeningPort(int port) {
        if (port != this.listeningPort) {
            this.listeningPort = port;
            if (this.isListening) {
                this.stopListening();
                this.startListening();
            }
        }
    }

    public boolean isEnabledByProperty() {
        return System.getProperty(DASHBOARD_PORT_PROPERTY) != null;
    }

    public synchronized void startListening() {
        if (this.isListening) {
            return;
        }
        try {
            this.listeningSocket = new ServerSocket(this.listeningPort, 50, LOCALHOST.toInetAddress());
            this.isListening = true;
            logger.info("Dashboard listening on " + LOCALHOST + ":" + this.listeningPort);
            this.executor.execute(this.createAcceptLoopRunnable(this.listeningSocket));
        }
        catch (IOException e) {
            logger.warning("Failed to create listening Dashboard socket on port " + this.listeningPort + ": " + e);
        }
    }

    public synchronized void stopListening() {
        if (!this.isListening) {
            return;
        }
        if (this.listeningSocket != null) {
            this.closeQuietly(this.listeningSocket);
            this.listeningSocket = null;
        }
        this.isListening = false;
    }

    public synchronized boolean isListening() {
        return this.isListening;
    }

    private Runnable createAcceptLoopRunnable(final ServerSocket ss) {
        return new Runnable(){

            @Override
            public void run() {
                Dashboard.this.acceptConnections(ss);
            }
        };
    }

    private void acceptConnections(ServerSocket ss) {
        try {
            while (true) {
                Socket s = ss.accept();
                this.executor.execute(new DashboardConnection(this, s));
            }
        }
        catch (IOException e) {
            if (!ss.isClosed()) {
                logger.warning("IOException on dashboard server socket: " + e);
            }
            this.stopListening();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderAll(PrintWriter writer) throws IOException {
        int fs;
        Dashboard dashboard = this;
        synchronized (dashboard) {
            fs = this.flags;
        }
        for (DashboardRenderable dr : this.renderables) {
            dr.dashboardRender(this, writer, fs);
        }
    }

    private void closeQuietly(ServerSocket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) {
        writer.println("[Dashboard]");
        writer.println();
    }

    @Override
    public void renderComponent(PrintWriter writer, int flags, Object component) throws IOException {
        if (!(component instanceof DashboardRenderable)) {
            return;
        }
        DashboardRenderable renderable = (DashboardRenderable)component;
        renderable.dashboardRender(this, writer, flags);
    }
}

