/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Matcher;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.DateMatcher;
import com.nulabinc.zxcvbn.matchers.DictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.L33tMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.RegexMatcher;
import com.nulabinc.zxcvbn.matchers.RepeatMatcher;
import com.nulabinc.zxcvbn.matchers.ReverseDictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.SequenceMatcher;
import com.nulabinc.zxcvbn.matchers.SpatialMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OmnibusMatcher
extends BaseMatcher {
    private final Map<String, Map<String, Integer>> dictionaries;

    public OmnibusMatcher(Map<String, Map<String, Integer>> dictionaries) {
        if (dictionaries == null) {
            dictionaries = new HashMap<String, Map<String, Integer>>();
        }
        this.dictionaries = dictionaries;
    }

    @Override
    public List<Match> execute(String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        ArrayList<BaseMatcher> matchers = new ArrayList<BaseMatcher>();
        matchers.add(new DictionaryMatcher(this.dictionaries));
        matchers.add(new ReverseDictionaryMatcher(this.dictionaries));
        matchers.add(new L33tMatcher(this.dictionaries));
        matchers.add(new SpatialMatcher());
        matchers.add(new RepeatMatcher());
        matchers.add(new SequenceMatcher());
        matchers.add(new RegexMatcher());
        matchers.add(new DateMatcher());
        for (Matcher matcher : matchers) {
            matches.addAll(matcher.execute(password));
        }
        return this.sorted(matches);
    }
}

