/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.crypto;

import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;
import org.libsodium.jni.keys.PrivateKey;
import org.libsodium.jni.keys.PublicKey;

@Deprecated
public class Box {
    private final byte[] privateKey;
    private final byte[] publicKey;

    public Box(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        Util.checkLength(publicKey, 32);
        Util.checkLength(privateKey, 32);
    }

    public Box(PublicKey publicKey, PrivateKey privateKey) {
        this(publicKey.toBytes(), privateKey.toBytes());
    }

    public Box(String publicKey, String privateKey, Encoder encoder) {
        this(encoder.decode(publicKey), encoder.decode(privateKey));
    }

    public byte[] encrypt(byte[] nonce, byte[] message) {
        Util.checkLength(nonce, 24);
        byte[] msg = Util.prependZeros(32, message);
        byte[] ct = new byte[msg.length];
        NaCl.sodium();
        Util.isValid(Sodium.crypto_box_curve25519xsalsa20poly1305(ct, msg, msg.length, nonce, this.publicKey, this.privateKey), "Encryption failed");
        return Util.removeZeros(16, ct);
    }

    public byte[] encrypt(String nonce, String message, Encoder encoder) {
        return this.encrypt(encoder.decode(nonce), encoder.decode(message));
    }

    public byte[] decrypt(byte[] nonce, byte[] ciphertext) {
        Util.checkLength(nonce, 24);
        byte[] ct = Util.prependZeros(16, ciphertext);
        byte[] message = new byte[ct.length];
        NaCl.sodium();
        Util.isValid(Sodium.crypto_box_curve25519xsalsa20poly1305_open(message, ct, message.length, nonce, this.publicKey, this.privateKey), "Decryption failed. Ciphertext failed verification.");
        return Util.removeZeros(32, message);
    }

    public byte[] decrypt(String nonce, String ciphertext, Encoder encoder) {
        return this.decrypt(encoder.decode(nonce), encoder.decode(ciphertext));
    }
}

