/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.symmetric;

import com.nulabinc.zxcvbn.AttackTimes;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.matchers.Match;
import com.pvryan.easycrypt.symmetric.ECPasswordStrengths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0003()*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006+"}, d2={"Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis;", "", "zxcvbnStrength", "Lcom/nulabinc/zxcvbn/Strength;", "(Lcom/nulabinc/zxcvbn/Strength;)V", "calcTime", "", "getCalcTime", "()J", "crackTimeSeconds", "Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimeSeconds;", "getCrackTimeSeconds", "()Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimeSeconds;", "crackTimesDisplay", "Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimesDisplay;", "getCrackTimesDisplay", "()Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimesDisplay;", "feedback", "Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$Feedback;", "getFeedback", "()Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$Feedback;", "guesses", "", "getGuesses", "()D", "guessesLog10", "getGuessesLog10", "password", "", "getPassword", "()Ljava/lang/String;", "sequence", "", "Lcom/nulabinc/zxcvbn/matchers/Match;", "getSequence", "()Ljava/util/List;", "strength", "Lcom/pvryan/easycrypt/symmetric/ECPasswordStrengths;", "getStrength", "()Lcom/pvryan/easycrypt/symmetric/ECPasswordStrengths;", "CrackTimeSeconds", "CrackTimesDisplay", "Feedback", "easycrypt_release"})
public final class ECPasswordAnalysis {
    @NotNull
    private final ECPasswordStrengths strength;
    private final double guesses;
    private final double guessesLog10;
    private final long calcTime;
    @NotNull
    private final CrackTimeSeconds crackTimeSeconds;
    @NotNull
    private final CrackTimesDisplay crackTimesDisplay;
    @NotNull
    private final Feedback feedback;
    @NotNull
    private final String password;
    @NotNull
    private final List<Match> sequence;

    @NotNull
    public final ECPasswordStrengths getStrength() {
        return this.strength;
    }

    public final double getGuesses() {
        return this.guesses;
    }

    public final double getGuessesLog10() {
        return this.guessesLog10;
    }

    public final long getCalcTime() {
        return this.calcTime;
    }

    @NotNull
    public final CrackTimeSeconds getCrackTimeSeconds() {
        return this.crackTimeSeconds;
    }

    @NotNull
    public final CrackTimesDisplay getCrackTimesDisplay() {
        return this.crackTimesDisplay;
    }

    @NotNull
    public final Feedback getFeedback() {
        return this.feedback;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final List<Match> getSequence() {
        return this.sequence;
    }

    public ECPasswordAnalysis(@NotNull Strength zxcvbnStrength) {
        ECPasswordStrengths eCPasswordStrengths;
        Intrinsics.checkParameterIsNotNull((Object)zxcvbnStrength, (String)"zxcvbnStrength");
        switch (zxcvbnStrength.getScore()) {
            case 0: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_VERY_WEAK;
                break;
            }
            case 1: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_WEAK;
                break;
            }
            case 2: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_AVERAGE;
                break;
            }
            case 3: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_STRONG;
                break;
            }
            case 4: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_VERY_STRONG;
                break;
            }
            default: {
                eCPasswordStrengths = ECPasswordStrengths.STRENGTH_VERY_WEAK;
            }
        }
        this.strength = eCPasswordStrengths;
        this.guesses = zxcvbnStrength.getGuesses();
        this.guessesLog10 = zxcvbnStrength.getGuessesLog10();
        this.calcTime = zxcvbnStrength.getCalcTime();
        AttackTimes.CrackTimeSeconds crackTimeSeconds = zxcvbnStrength.getCrackTimeSeconds();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimeSeconds, (String)"zxcvbnStrength.crackTimeSeconds");
        double d = crackTimeSeconds.getOfflineFastHashing1e10PerSecond();
        AttackTimes.CrackTimeSeconds crackTimeSeconds2 = zxcvbnStrength.getCrackTimeSeconds();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimeSeconds2, (String)"zxcvbnStrength.crackTimeSeconds");
        double d2 = crackTimeSeconds2.getOfflineSlowHashing1e4perSecond();
        AttackTimes.CrackTimeSeconds crackTimeSeconds3 = zxcvbnStrength.getCrackTimeSeconds();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimeSeconds3, (String)"zxcvbnStrength.crackTimeSeconds");
        double d3 = crackTimeSeconds3.getOnlineNoThrottling10perSecond();
        AttackTimes.CrackTimeSeconds crackTimeSeconds4 = zxcvbnStrength.getCrackTimeSeconds();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimeSeconds4, (String)"zxcvbnStrength.crackTimeSeconds");
        this.crackTimeSeconds = new CrackTimeSeconds(d, d2, d3, crackTimeSeconds4.getOnlineThrottling100perHour());
        AttackTimes.CrackTimesDisplay crackTimesDisplay = zxcvbnStrength.getCrackTimesDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimesDisplay, (String)"zxcvbnStrength.crackTimesDisplay");
        String string = crackTimesDisplay.getOfflineFastHashing1e10PerSecond();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zxcvbnStrength.crackTime\u2026eFastHashing1e10PerSecond");
        AttackTimes.CrackTimesDisplay crackTimesDisplay2 = zxcvbnStrength.getCrackTimesDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimesDisplay2, (String)"zxcvbnStrength.crackTimesDisplay");
        String string2 = crackTimesDisplay2.getOfflineSlowHashing1e4perSecond();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"zxcvbnStrength.crackTime\u2026neSlowHashing1e4perSecond");
        AttackTimes.CrackTimesDisplay crackTimesDisplay3 = zxcvbnStrength.getCrackTimesDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimesDisplay3, (String)"zxcvbnStrength.crackTimesDisplay");
        String string3 = crackTimesDisplay3.getOnlineNoThrottling10perSecond();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"zxcvbnStrength.crackTime\u2026neNoThrottling10perSecond");
        AttackTimes.CrackTimesDisplay crackTimesDisplay4 = zxcvbnStrength.getCrackTimesDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)crackTimesDisplay4, (String)"zxcvbnStrength.crackTimesDisplay");
        String string4 = crackTimesDisplay4.getOnlineThrottling100perHour();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"zxcvbnStrength.crackTime\u2026nlineThrottling100perHour");
        this.crackTimesDisplay = new CrackTimesDisplay(string, string2, string3, string4);
        com.nulabinc.zxcvbn.Feedback feedback = zxcvbnStrength.getFeedback();
        Intrinsics.checkExpressionValueIsNotNull((Object)feedback, (String)"zxcvbnStrength.feedback");
        List list = feedback.getSuggestions();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"zxcvbnStrength.feedback.suggestions");
        com.nulabinc.zxcvbn.Feedback feedback2 = zxcvbnStrength.getFeedback();
        Intrinsics.checkExpressionValueIsNotNull((Object)feedback2, (String)"zxcvbnStrength.feedback");
        String string5 = feedback2.getWarning();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"zxcvbnStrength.feedback.warning");
        this.feedback = new Feedback(list, string5);
        String string6 = zxcvbnStrength.getPassword();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"zxcvbnStrength.password");
        this.password = string6;
        List list2 = zxcvbnStrength.getSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"zxcvbnStrength.sequence");
        this.sequence = list2;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimeSeconds;", "", "offlineFastHashing1e10PerSecond", "", "offlineSlowHashing1e4perSecond", "onlineNoThrottling10perSecond", "onlineThrottling100perHour", "(DDDD)V", "getOfflineFastHashing1e10PerSecond", "()D", "getOfflineSlowHashing1e4perSecond", "getOnlineNoThrottling10perSecond", "getOnlineThrottling100perHour", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "easycrypt_release"})
    public static final class CrackTimeSeconds {
        private final double offlineFastHashing1e10PerSecond;
        private final double offlineSlowHashing1e4perSecond;
        private final double onlineNoThrottling10perSecond;
        private final double onlineThrottling100perHour;

        public final double getOfflineFastHashing1e10PerSecond() {
            return this.offlineFastHashing1e10PerSecond;
        }

        public final double getOfflineSlowHashing1e4perSecond() {
            return this.offlineSlowHashing1e4perSecond;
        }

        public final double getOnlineNoThrottling10perSecond() {
            return this.onlineNoThrottling10perSecond;
        }

        public final double getOnlineThrottling100perHour() {
            return this.onlineThrottling100perHour;
        }

        public CrackTimeSeconds(double offlineFastHashing1e10PerSecond, double offlineSlowHashing1e4perSecond, double onlineNoThrottling10perSecond, double onlineThrottling100perHour) {
            this.offlineFastHashing1e10PerSecond = offlineFastHashing1e10PerSecond;
            this.offlineSlowHashing1e4perSecond = offlineSlowHashing1e4perSecond;
            this.onlineNoThrottling10perSecond = onlineNoThrottling10perSecond;
            this.onlineThrottling100perHour = onlineThrottling100perHour;
        }

        public final double component1() {
            return this.offlineFastHashing1e10PerSecond;
        }

        public final double component2() {
            return this.offlineSlowHashing1e4perSecond;
        }

        public final double component3() {
            return this.onlineNoThrottling10perSecond;
        }

        public final double component4() {
            return this.onlineThrottling100perHour;
        }

        @NotNull
        public final CrackTimeSeconds copy(double offlineFastHashing1e10PerSecond, double offlineSlowHashing1e4perSecond, double onlineNoThrottling10perSecond, double onlineThrottling100perHour) {
            return new CrackTimeSeconds(offlineFastHashing1e10PerSecond, offlineSlowHashing1e4perSecond, onlineNoThrottling10perSecond, onlineThrottling100perHour);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CrackTimeSeconds copy$default(CrackTimeSeconds crackTimeSeconds, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = crackTimeSeconds.offlineFastHashing1e10PerSecond;
            }
            if ((n & 2) != 0) {
                d2 = crackTimeSeconds.offlineSlowHashing1e4perSecond;
            }
            if ((n & 4) != 0) {
                d3 = crackTimeSeconds.onlineNoThrottling10perSecond;
            }
            if ((n & 8) != 0) {
                d4 = crackTimeSeconds.onlineThrottling100perHour;
            }
            return crackTimeSeconds.copy(d, d2, d3, d4);
        }

        public String toString() {
            return "CrackTimeSeconds(offlineFastHashing1e10PerSecond=" + this.offlineFastHashing1e10PerSecond + ", offlineSlowHashing1e4perSecond=" + this.offlineSlowHashing1e4perSecond + ", onlineNoThrottling10perSecond=" + this.onlineNoThrottling10perSecond + ", onlineThrottling100perHour=" + this.onlineThrottling100perHour + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.offlineFastHashing1e10PerSecond);
            long l2 = Double.doubleToLongBits(this.offlineSlowHashing1e4perSecond);
            long l3 = Double.doubleToLongBits(this.onlineNoThrottling10perSecond);
            long l4 = Double.doubleToLongBits(this.onlineThrottling100perHour);
            return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CrackTimeSeconds)) break block3;
                    CrackTimeSeconds crackTimeSeconds = (CrackTimeSeconds)object;
                    if (Double.compare(this.offlineFastHashing1e10PerSecond, crackTimeSeconds.offlineFastHashing1e10PerSecond) != 0 || Double.compare(this.offlineSlowHashing1e4perSecond, crackTimeSeconds.offlineSlowHashing1e4perSecond) != 0 || Double.compare(this.onlineNoThrottling10perSecond, crackTimeSeconds.onlineNoThrottling10perSecond) != 0 || Double.compare(this.onlineThrottling100perHour, crackTimeSeconds.onlineThrottling100perHour) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$CrackTimesDisplay;", "", "offlineFastHashing1e10PerSecond", "", "offlineSlowHashing1e4perSecond", "onlineNoThrottling10perSecond", "onlineThrottling100perHour", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOfflineFastHashing1e10PerSecond", "()Ljava/lang/String;", "getOfflineSlowHashing1e4perSecond", "getOnlineNoThrottling10perSecond", "getOnlineThrottling100perHour", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "easycrypt_release"})
    public static final class CrackTimesDisplay {
        @NotNull
        private final String offlineFastHashing1e10PerSecond;
        @NotNull
        private final String offlineSlowHashing1e4perSecond;
        @NotNull
        private final String onlineNoThrottling10perSecond;
        @NotNull
        private final String onlineThrottling100perHour;

        @NotNull
        public final String getOfflineFastHashing1e10PerSecond() {
            return this.offlineFastHashing1e10PerSecond;
        }

        @NotNull
        public final String getOfflineSlowHashing1e4perSecond() {
            return this.offlineSlowHashing1e4perSecond;
        }

        @NotNull
        public final String getOnlineNoThrottling10perSecond() {
            return this.onlineNoThrottling10perSecond;
        }

        @NotNull
        public final String getOnlineThrottling100perHour() {
            return this.onlineThrottling100perHour;
        }

        public CrackTimesDisplay(@NotNull String offlineFastHashing1e10PerSecond, @NotNull String offlineSlowHashing1e4perSecond, @NotNull String onlineNoThrottling10perSecond, @NotNull String onlineThrottling100perHour) {
            Intrinsics.checkParameterIsNotNull((Object)offlineFastHashing1e10PerSecond, (String)"offlineFastHashing1e10PerSecond");
            Intrinsics.checkParameterIsNotNull((Object)offlineSlowHashing1e4perSecond, (String)"offlineSlowHashing1e4perSecond");
            Intrinsics.checkParameterIsNotNull((Object)onlineNoThrottling10perSecond, (String)"onlineNoThrottling10perSecond");
            Intrinsics.checkParameterIsNotNull((Object)onlineThrottling100perHour, (String)"onlineThrottling100perHour");
            this.offlineFastHashing1e10PerSecond = offlineFastHashing1e10PerSecond;
            this.offlineSlowHashing1e4perSecond = offlineSlowHashing1e4perSecond;
            this.onlineNoThrottling10perSecond = onlineNoThrottling10perSecond;
            this.onlineThrottling100perHour = onlineThrottling100perHour;
        }

        @NotNull
        public final String component1() {
            return this.offlineFastHashing1e10PerSecond;
        }

        @NotNull
        public final String component2() {
            return this.offlineSlowHashing1e4perSecond;
        }

        @NotNull
        public final String component3() {
            return this.onlineNoThrottling10perSecond;
        }

        @NotNull
        public final String component4() {
            return this.onlineThrottling100perHour;
        }

        @NotNull
        public final CrackTimesDisplay copy(@NotNull String offlineFastHashing1e10PerSecond, @NotNull String offlineSlowHashing1e4perSecond, @NotNull String onlineNoThrottling10perSecond, @NotNull String onlineThrottling100perHour) {
            Intrinsics.checkParameterIsNotNull((Object)offlineFastHashing1e10PerSecond, (String)"offlineFastHashing1e10PerSecond");
            Intrinsics.checkParameterIsNotNull((Object)offlineSlowHashing1e4perSecond, (String)"offlineSlowHashing1e4perSecond");
            Intrinsics.checkParameterIsNotNull((Object)onlineNoThrottling10perSecond, (String)"onlineNoThrottling10perSecond");
            Intrinsics.checkParameterIsNotNull((Object)onlineThrottling100perHour, (String)"onlineThrottling100perHour");
            return new CrackTimesDisplay(offlineFastHashing1e10PerSecond, offlineSlowHashing1e4perSecond, onlineNoThrottling10perSecond, onlineThrottling100perHour);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CrackTimesDisplay copy$default(CrackTimesDisplay crackTimesDisplay, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = crackTimesDisplay.offlineFastHashing1e10PerSecond;
            }
            if ((n & 2) != 0) {
                string2 = crackTimesDisplay.offlineSlowHashing1e4perSecond;
            }
            if ((n & 4) != 0) {
                string3 = crackTimesDisplay.onlineNoThrottling10perSecond;
            }
            if ((n & 8) != 0) {
                string4 = crackTimesDisplay.onlineThrottling100perHour;
            }
            return crackTimesDisplay.copy(string, string2, string3, string4);
        }

        public String toString() {
            return "CrackTimesDisplay(offlineFastHashing1e10PerSecond=" + this.offlineFastHashing1e10PerSecond + ", offlineSlowHashing1e4perSecond=" + this.offlineSlowHashing1e4perSecond + ", onlineNoThrottling10perSecond=" + this.onlineNoThrottling10perSecond + ", onlineThrottling100perHour=" + this.onlineThrottling100perHour + ")";
        }

        public int hashCode() {
            String string = this.offlineFastHashing1e10PerSecond;
            String string2 = this.offlineSlowHashing1e4perSecond;
            String string3 = this.onlineNoThrottling10perSecond;
            String string4 = this.onlineThrottling100perHour;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CrackTimesDisplay)) break block3;
                    CrackTimesDisplay crackTimesDisplay = (CrackTimesDisplay)object;
                    if (!Intrinsics.areEqual((Object)this.offlineFastHashing1e10PerSecond, (Object)crackTimesDisplay.offlineFastHashing1e10PerSecond) || !Intrinsics.areEqual((Object)this.offlineSlowHashing1e4perSecond, (Object)crackTimesDisplay.offlineSlowHashing1e4perSecond) || !Intrinsics.areEqual((Object)this.onlineNoThrottling10perSecond, (Object)crackTimesDisplay.onlineNoThrottling10perSecond) || !Intrinsics.areEqual((Object)this.onlineThrottling100perHour, (Object)crackTimesDisplay.onlineThrottling100perHour)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/pvryan/easycrypt/symmetric/ECPasswordAnalysis$Feedback;", "", "suggestions", "", "", "warning", "(Ljava/util/List;Ljava/lang/String;)V", "getSuggestions", "()Ljava/util/List;", "getWarning", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "easycrypt_release"})
    public static final class Feedback {
        @NotNull
        private final List<String> suggestions;
        @NotNull
        private final String warning;

        @NotNull
        public final List<String> getSuggestions() {
            return this.suggestions;
        }

        @NotNull
        public final String getWarning() {
            return this.warning;
        }

        public Feedback(@NotNull List<String> suggestions, @NotNull String warning) {
            Intrinsics.checkParameterIsNotNull(suggestions, (String)"suggestions");
            Intrinsics.checkParameterIsNotNull((Object)warning, (String)"warning");
            this.suggestions = suggestions;
            this.warning = warning;
        }

        @NotNull
        public final List<String> component1() {
            return this.suggestions;
        }

        @NotNull
        public final String component2() {
            return this.warning;
        }

        @NotNull
        public final Feedback copy(@NotNull List<String> suggestions, @NotNull String warning) {
            Intrinsics.checkParameterIsNotNull(suggestions, (String)"suggestions");
            Intrinsics.checkParameterIsNotNull((Object)warning, (String)"warning");
            return new Feedback(suggestions, warning);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Feedback copy$default(Feedback feedback, List list, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = feedback.suggestions;
            }
            if ((n & 2) != 0) {
                string = feedback.warning;
            }
            return feedback.copy(list, string);
        }

        public String toString() {
            return "Feedback(suggestions=" + this.suggestions + ", warning=" + this.warning + ")";
        }

        public int hashCode() {
            List<String> list = this.suggestions;
            String string = this.warning;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Feedback)) break block3;
                    Feedback feedback = (Feedback)object;
                    if (!Intrinsics.areEqual(this.suggestions, feedback.suggestions) || !Intrinsics.areEqual((Object)this.warning, (Object)feedback.warning)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

