/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import com.facebook.crypto.mac.NativeMac;
import java.io.IOException;
import java.io.OutputStream;

public class NativeMacLayeredOutputStream
extends OutputStream {
    private final NativeMac mMac;
    private final OutputStream mOutputDelegate;
    private boolean mMacAppended = false;

    public NativeMacLayeredOutputStream(NativeMac mac, OutputStream outputDelegate) {
        this.mMac = mac;
        this.mOutputDelegate = outputDelegate;
    }

    @Override
    public void close() throws IOException {
        try {
            this.appendMac();
        }
        finally {
            this.mOutputDelegate.close();
        }
    }

    private void appendMac() throws IOException {
        if (this.mMacAppended) {
            return;
        }
        this.mMacAppended = true;
        try {
            byte[] mac = this.mMac.doFinal();
            this.mOutputDelegate.write(mac);
        }
        finally {
            this.mMac.destroy();
        }
    }

    @Override
    public void flush() throws IOException {
        this.mOutputDelegate.flush();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.mMac.update(buffer, offset, count);
        this.mOutputDelegate.write(buffer, offset, count);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.mMac.update((byte)oneByte);
        this.mOutputDelegate.write(oneByte);
    }
}

