/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class BetterCipherInputStream
extends FilterInputStream {
    private static final int UPDATE_BUFFER_SIZE = 256;
    private final Cipher mCipher;
    private final byte[] mUpdateBuffer;

    public BetterCipherInputStream(InputStream in, Cipher cipher) {
        super(in);
        this.mCipher = cipher;
        this.mUpdateBuffer = new byte[256];
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int read = this.in.read(buffer, offset, count);
        if (read == -1) {
            return -1;
        }
        int times = read / 256;
        int remainder = read % 256;
        int originalOffset = offset;
        int currentReadOffset = offset;
        try {
            for (int i = 0; i < times; ++i) {
                int bytesDecrypted = this.mCipher.update(buffer, offset, 256, this.mUpdateBuffer);
                System.arraycopy(this.mUpdateBuffer, 0, buffer, currentReadOffset, bytesDecrypted);
                currentReadOffset += bytesDecrypted;
                offset += 256;
            }
            if (remainder > 0) {
                int bytesDecrypted = this.mCipher.update(buffer, offset, remainder, this.mUpdateBuffer);
                System.arraycopy(this.mUpdateBuffer, 0, buffer, currentReadOffset, bytesDecrypted);
                currentReadOffset += bytesDecrypted;
            }
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return currentReadOffset - originalOffset;
    }
}

