/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.crypto.mac;

import com.facebook.crypto.exception.CryptoInitializationException;
import com.facebook.crypto.proguard.annotations.DoNotStrip;
import com.facebook.crypto.util.Assertions;
import com.facebook.crypto.util.NativeCryptoLibrary;
import java.io.IOException;

@DoNotStrip
public class NativeMac {
    public static final String FAILURE = "Failure";
    public static final int KEY_LENGTH = 64;
    private static final String MAC_ALREADY_INIT = "Mac has already been initialized";
    private static final String MAC_NOT_INIT = "Mac has not been initialized";
    private static final String MAC_NOT_FINALIZED = "Mac has not been finalized";
    private STATE mCurrentState = STATE.UNINITIALIZED;
    private final NativeCryptoLibrary mNativeCryptoLibrary;
    @DoNotStrip
    private long mCtxPtr;

    public NativeMac(NativeCryptoLibrary nativeCryptoLibrary) {
        this.mNativeCryptoLibrary = nativeCryptoLibrary;
    }

    public void init(byte[] key, int len) throws CryptoInitializationException, IOException {
        Assertions.checkState(this.mCurrentState == STATE.UNINITIALIZED, MAC_ALREADY_INIT);
        this.mNativeCryptoLibrary.ensureCryptoLoaded();
        if (this.nativeInit(key, len) == NativeMac.nativeFailure()) {
            throw new IOException(FAILURE);
        }
        this.mCurrentState = STATE.INITIALIZED;
    }

    public void update(byte read) throws IOException {
        Assertions.checkState(this.mCurrentState == STATE.INITIALIZED, MAC_NOT_INIT);
        if (this.nativeUpdate(read) == NativeMac.nativeFailure()) {
            throw new IOException(FAILURE);
        }
    }

    public void update(byte[] buffer, int offset, int len) throws IOException {
        Assertions.checkState(this.mCurrentState == STATE.INITIALIZED, MAC_NOT_INIT);
        if (this.nativeUpdate(buffer, offset, len) == NativeMac.nativeFailure()) {
            throw new IOException(FAILURE);
        }
    }

    public byte[] doFinal() throws IOException {
        Assertions.checkState(this.mCurrentState == STATE.INITIALIZED, MAC_NOT_INIT);
        this.mCurrentState = STATE.FINALIZED;
        byte[] toReturn = this.nativeDoFinal();
        if (toReturn == null) {
            throw new IOException(FAILURE);
        }
        return toReturn;
    }

    public void destroy() throws IOException {
        Assertions.checkState(this.mCurrentState == STATE.FINALIZED, MAC_NOT_FINALIZED);
        if (this.nativeDestroy() == NativeMac.nativeFailure()) {
            throw new IOException(FAILURE);
        }
        this.mCurrentState = STATE.UNINITIALIZED;
    }

    public int getMacLength() {
        return this.nativeGetMacLength();
    }

    private static native int nativeFailure();

    private native int nativeInit(byte[] var1, int var2);

    private native int nativeUpdate(byte var1);

    private native int nativeUpdate(byte[] var1, int var2, int var3);

    private native byte[] nativeDoFinal();

    private native int nativeDestroy();

    private native int nativeGetMacLength();

    private static enum STATE {
        UNINITIALIZED,
        INITIALIZED,
        FINALIZED;

    }
}

