/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.DirectoryServer;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.RouterImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectoryServerImpl
extends RouterImpl
implements DirectoryServer {
    private List<KeyCertificate> certificates = new ArrayList<KeyCertificate>();
    private boolean isHiddenServiceAuthority = false;
    private boolean isBridgeAuthority = false;
    private boolean isExtraInfoCache = false;
    private int port;
    private HexDigest v3Ident;

    DirectoryServerImpl(RouterStatus status) {
        super(null, status);
    }

    void setHiddenServiceAuthority() {
        this.isHiddenServiceAuthority = true;
    }

    void unsetHiddenServiceAuthority() {
        this.isHiddenServiceAuthority = false;
    }

    void setBridgeAuthority() {
        this.isBridgeAuthority = true;
    }

    void setExtraInfoCache() {
        this.isExtraInfoCache = true;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setV3Ident(HexDigest fingerprint) {
        this.v3Ident = fingerprint;
    }

    public boolean isTrustedAuthority() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isV2Authority() {
        return this.hasFlag("Authority") && this.hasFlag("V2Dir");
    }

    @Override
    public boolean isV3Authority() {
        return this.hasFlag("Authority") && this.v3Ident != null;
    }

    @Override
    public boolean isHiddenServiceAuthority() {
        return this.isHiddenServiceAuthority;
    }

    @Override
    public boolean isBridgeAuthority() {
        return this.isBridgeAuthority;
    }

    @Override
    public boolean isExtraInfoCache() {
        return this.isExtraInfoCache;
    }

    @Override
    public HexDigest getV3Identity() {
        return this.v3Ident;
    }

    @Override
    public KeyCertificate getCertificateByFingerprint(HexDigest fingerprint) {
        for (KeyCertificate kc : this.getCertificates()) {
            if (!kc.getAuthoritySigningKey().getFingerprint().equals(fingerprint)) continue;
            return kc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyCertificate> getCertificates() {
        List<KeyCertificate> list = this.certificates;
        synchronized (list) {
            this.purgeExpiredCertificates();
            this.purgeOldCertificates();
            return new ArrayList<KeyCertificate>(this.certificates);
        }
    }

    private void purgeExpiredCertificates() {
        Iterator<KeyCertificate> it = this.certificates.iterator();
        while (it.hasNext()) {
            KeyCertificate elem = it.next();
            if (!elem.isExpired()) continue;
            it.remove();
        }
    }

    private void purgeOldCertificates() {
        if (this.certificates.size() < 2) {
            return;
        }
        KeyCertificate newest = this.getNewestCertificate();
        Iterator<KeyCertificate> it = this.certificates.iterator();
        while (it.hasNext()) {
            KeyCertificate elem = it.next();
            if (elem == newest || !this.isMoreThan48HoursOlder(newest, elem)) continue;
            it.remove();
        }
    }

    private KeyCertificate getNewestCertificate() {
        KeyCertificate newest = null;
        for (KeyCertificate kc : this.certificates) {
            if (newest != null && this.getPublishedMilliseconds(newest) <= this.getPublishedMilliseconds(kc)) continue;
            newest = kc;
        }
        return newest;
    }

    private boolean isMoreThan48HoursOlder(KeyCertificate newer, KeyCertificate older) {
        long milliseconds = 172800000L;
        return this.getPublishedMilliseconds(newer) - this.getPublishedMilliseconds(older) > 172800000L;
    }

    private long getPublishedMilliseconds(KeyCertificate certificate) {
        return certificate.getKeyPublishedTime().getDate().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCertificate(KeyCertificate certificate) {
        if (!certificate.getAuthorityFingerprint().equals(this.v3Ident)) {
            throw new IllegalArgumentException("This certificate does not appear to belong to this directory authority");
        }
        List<KeyCertificate> list = this.certificates;
        synchronized (list) {
            this.certificates.add(certificate);
        }
    }

    @Override
    public String toString() {
        if (this.v3Ident != null) {
            return "(Directory: " + this.getNickname() + " " + this.getAddress() + ":" + this.port + " fingerprint=" + this.getIdentityHash() + " v3ident=" + this.v3Ident + ")";
        }
        return "(Directory: " + this.getNickname() + " " + this.getAddress() + ":" + this.port + " fingerprint=" + this.getIdentityHash() + ")";
    }
}

